/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance.myob.mapping;

import java.util.List;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.integration.accounting.formats.ReportFormat;
import ordermate.database.integration.accounting.reports.AccountingFinanceReport;
import ordermate.database.integration.accounting.reports.AccountingReport;
import ordermate.database.integration.accounting.reports.AccountingSalesReport;
import ordermate.integration.exportmapping.ExportTemplate;
import ordermate.integration.finance.myob.mapping.DoubleEntryMapping;
import ordermate.integration.finance.myob.mapping.FinancePriceFormat;
import ordermate.integration.finance.myob.mapping.FinanceTaxCodeFormat;
import ordermate.integration.finance.myob.templates.GeneralJournalTemplate;

public class SalesAndFinanceMapping
extends DoubleEntryMapping {
    private GeneralJournalTemplate template;
    private ReportFormat reportFormatter;

    public SalesAndFinanceMapping(List<AccountingReport> allReports, ReportFormat reportFormatter) {
        super(allReports, false);
        this.reportFormatter = reportFormatter;
        this.initMapping();
        this.initialized = true;
        this.checkInitialized();
        FinancePriceFormat priceFormat = new FinancePriceFormat(reportFormatter.getPriceFormat());
        this.setFormat(this.template.creditAmountIncTax, priceFormat);
        this.setFormat(this.template.creditAmountExTax, priceFormat);
        this.setFormat(this.template.debitAmountIncTax, priceFormat);
        this.setFormat(this.template.debitAmountExTax, priceFormat);
        this.setFormat(this.template.taxAmount, priceFormat);
        this.setFormat(this.template.taxCode, new FinanceTaxCodeFormat());
    }

    @Override
    protected Class getBusinessObjectClass() {
        return AccountingReport.class;
    }

    @Override
    protected ExportTemplate getTemplate() {
        return this.template;
    }

    @Override
    protected void initMapping() {
        super.initMapping();
        this.template = new GeneralJournalTemplate();
        this.addCreditMapping(this.template.journalNumber, this.createAccessor("getJournalNumber"));
        this.addCreditMapping(this.template.date, AccountingSalesReport.Properties.DATE);
        this.addCreditMapping(this.template.gstBasReporting, "S");
        this.addCreditMapping(this.template.taxInclusive, "1");
        this.addCreditMapping(this.template.accountNumber, this.createAccessor("getGLCode"));
        this.addCreditMapping(this.template.creditAmountIncTax, AccountingSalesReport.Properties.NETT_SALES);
        this.addCreditMapping(this.template.creditAmountExTax, AccountingSalesReport.Properties.NETT_SALES_EX);
        this.addCreditMapping(this.template.debitAmountIncTax, AccountingSalesReport.Properties.NETT_SALES_NEG);
        this.addCreditMapping(this.template.debitAmountExTax, AccountingSalesReport.Properties.NETT_SALES_NEG_EX);
        this.addCreditMapping(this.template.taxCode, AccountingSalesReport.Properties.TAX_CODE);
        this.addCreditMapping(this.template.taxAmount, AccountingSalesReport.Properties.TAX_AMOUNT);
        this.addCreditMapping(this.template.allocationMemo, this.createAccessor("getAllocationMemo"));
        this.addDebitMapping(this.template.journalNumber, this.createAccessor("getJournalNumber"));
        this.addDebitMapping(this.template.date, AccountingFinanceReport.Properties.DATE);
        this.addDebitMapping(this.template.memo, this.createAccessor("getMemo"));
        this.addDebitMapping(this.template.gstBasReporting, "S");
        this.addDebitMapping(this.template.taxInclusive, "1");
        this.addDebitMapping(this.template.accountNumber, this.createAccessor("getGLCode"));
        this.addDebitMapping(this.template.debitAmountIncTax, AccountingFinanceReport.Properties.AMOUNT);
        this.addDebitMapping(this.template.debitAmountExTax, AccountingFinanceReport.Properties.AMOUNT_EX);
        this.addDebitMapping(this.template.creditAmountIncTax, AccountingFinanceReport.Properties.AMOUNT_NEG);
        this.addDebitMapping(this.template.creditAmountExTax, AccountingFinanceReport.Properties.AMOUNT_NEG_EX);
        this.addDebitMapping(this.template.taxAmount, AccountingFinanceReport.Properties.TAX_AMOUNT);
        this.addDebitMapping(this.template.taxCode, this.createAccessor("getTaxCode"));
        this.addDebitMapping(this.template.allocationMemo, this.createAccessor("getAllocationMemo"));
    }

    public String getAccountName(AccountingReport report) {
        return this.reportFormatter.getAccountName(report);
    }

    @Override
    public boolean isEmptyLineBetweenSets() {
        return this.reportFormatter.isEmptyLineBetweenSets();
    }

    public String getJournalNumber(AccountingReport report) {
        return this.reportFormatter.getJournalNumber(report);
    }

    public String getGLCode(AccountingReport report) {
        return this.reportFormatter.getGLCode(report);
    }

    public String getAllocationMemo(AccountingReport report) {
        return report.getAllocationMemo();
    }

    public String getMemo(AccountingReport report) {
        return this.reportFormatter.getMemo(report);
    }

    public TaxCode getTaxCode(AccountingReport report) {
        return report.getTaxCode();
    }
}

