/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance.myob.mapping;

import java.util.List;
import ordermate.database.integration.accounting.formats.ReportFormat;
import ordermate.database.misc.SystemProperty;
import ordermate.integration.exportmapping.ExportTemplate;
import ordermate.integration.exportmapping.SingleEntryMapping;
import ordermate.integration.finance.myob.mapping.FinancePriceFormat;
import ordermate.integration.finance.myob.mapping.FinanceTaxCodeFormat;
import ordermate.integration.finance.myob.templates.MYOBServicePurchaseTemplate;
import ordermate.reports.accounting.InvoiceReport;

public class StockInvoiceMYOBServicePurchasesMapping
extends SingleEntryMapping {
    private MYOBServicePurchaseTemplate template;
    private ReportFormat reportFormatter;

    public StockInvoiceMYOBServicePurchasesMapping(List<? extends InvoiceReport> stockInvoices, ReportFormat reportFormatter) {
        super(stockInvoices, false);
        this.reportFormatter = reportFormatter;
        if (stockInvoices.size() > 0 && stockInvoices.get(0).getClass() != this.getBusinessObjectClass()) {
            throw new IllegalArgumentException("Account list should contain MYOBAccounts");
        }
        this.initMapping();
        this.initialized = true;
        FinancePriceFormat priceFormat = new FinancePriceFormat(reportFormatter.getPriceFormat());
        this.setFormat(this.template.amount, priceFormat);
        this.setFormat(this.template.amountPaid, priceFormat);
        this.setFormat(this.template.inclusive, priceFormat);
        this.setFormat(this.template.incTaxAmount, priceFormat);
        FinanceTaxCodeFormat taxFormat = new FinanceTaxCodeFormat();
        this.setFormat(this.template.taxCode, taxFormat);
    }

    @Override
    protected void initMapping() {
        super.initMapping();
        this.template = new MYOBServicePurchaseTemplate();
        if (!this.reportFormatter.isGLCodeUsedForAccountId()) {
            this.addMapping(this.template.accountNum, InvoiceReport.Properties.ACCOUNT_NAME);
        } else {
            this.addMapping(this.template.accountNum, InvoiceReport.Properties.GL_CODE);
        }
        this.addMapping(this.template.inclusive, "X");
        this.addMapping(this.template.lastName, InvoiceReport.Properties.SUPPLIER_NAME);
        this.addMapping(this.template.date, InvoiceReport.Properties.INVOICE_DATE);
        this.addMapping(this.template.deliveryStatus, "A");
        this.addMapping(this.template.incTaxAmount, InvoiceReport.Properties.ITEM_AMOUNT);
        this.addMapping(this.template.amount, InvoiceReport.Properties.EX_TAX_AMOUNT);
        this.addMapping(this.template.taxAmount, InvoiceReport.Properties.ITEM_TAX);
        this.addMapping(this.template.taxCode, InvoiceReport.Properties.TAX_CODE);
        this.addMapping(this.template.supplierInvNum, InvoiceReport.Properties.SUPPLIER_INVOICE_NUMBER);
        this.addMapping(this.template.purchaseNum, InvoiceReport.Properties.ORDER_NUMBER);
        this.addMapping(this.template.description, InvoiceReport.Properties.DESCRIPTION);
        this.addMapping(this.template.freightAmountIncTax, InvoiceReport.Properties.FREIGHT_AMOUNT);
        this.addMapping(this.template.freightAmount, InvoiceReport.Properties.FREIGHT_EX_TAX);
        this.addMapping(this.template.freightTaxAmount, InvoiceReport.Properties.FRIEGHT_TAX_AMOUNT);
        this.addMapping(this.template.freightTaxCode, SystemProperty.getInstance().getBaseTaxLabel());
        this.addMapping(this.template.terms, "0");
        this.addMapping(this.template.discountDays, "0");
        this.addMapping(this.template.balanceDueDays, "0");
        this.addMapping(this.template.discountPerc, "0");
        this.addMapping(this.template.journalMemo, InvoiceReport.Properties.JOURNAL_MEMO);
        this.addMapping(this.template.amountPaid, "0.00");
    }

    @Override
    protected String getRecordID(Object obj) {
        InvoiceReport report = (InvoiceReport)obj;
        return report.getInvoiceId() + "";
    }

    @Override
    protected Class getBusinessObjectClass() {
        return InvoiceReport.class;
    }

    @Override
    protected ExportTemplate getTemplate() {
        return this.template;
    }

    @Override
    public boolean isEmptyLineBetweenSets() {
        return this.reportFormatter.isEmptyLineBetweenSets();
    }
}

