/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance.quickbooks;

import au.com.ordermate.gui.GuiHandler;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.integration.accounting.AccountingIntegrationConfig;
import ordermate.database.integration.accounting.formats.ReportFormat;
import ordermate.database.integration.accounting.reports.AccountingReport;
import ordermate.database.stock.StockInvoice;
import ordermate.integration.csv.CSVExporter;
import ordermate.integration.finance.AccountingExportFunction;
import ordermate.integration.finance.AccountingExportParams;
import ordermate.integration.finance.AccountingExporter;
import ordermate.integration.finance.myob.mapping.FinanceExportStyle;
import ordermate.integration.finance.myob.mapping.SalesAndFinanceMapping;
import ordermate.integration.finance.myob.mapping.StockInvoiceMYOBServicePurchasesMapping;
import ordermate.integration.finance.quickbooks.QuickbooksReportFormat;
import ordermate.reports.accounting.InvoiceReport;

public class QuickbooksExporter
extends AccountingExporter {
    public QuickbooksExporter() {
        this(null, null);
    }

    public QuickbooksExporter(GuiHandler guiHandler, EventContext context) {
        super(guiHandler, context);
    }

    @Override
    protected String exportSalesAndTakings(AccountingExportParams param) {
        SalesAndFinanceMapping mapping;
        CSVExporter exporter;
        String reason = super.exportSalesAndTakings(param);
        if (reason != null) {
            return reason;
        }
        List<AccountingReport> salesAndFinanceReportList = this.getSalesAndFinanceReport().generateReport();
        if (AccountingIntegrationConfig.getInstance().isExportReconciliationSeparately()) {
            List<AccountingReport> reconciliationReportList = this.getAndStripReconciliationEntries(salesAndFinanceReportList);
            SalesAndFinanceMapping mapping2 = new SalesAndFinanceMapping(reconciliationReportList, new QuickbooksReportFormat());
            CSVExporter exporter2 = new CSVExporter(mapping2);
            exporter2.createExportFile(this.getReconciliationFileName(param.getFileName(), param));
        }
        if ((exporter = new CSVExporter(mapping = new SalesAndFinanceMapping(salesAndFinanceReportList, new QuickbooksReportFormat()))).createExportFile(param.getFileName())) {
            return null;
        }
        return "create Export File fails ";
    }

    @Override
    protected String exportStockInvoices(AccountingExportParams param) {
        QuickbooksReportFormat reportFormatter;
        InvoiceReport report = new InvoiceReport(param.getStartDate(), param.getEndDate());
        List<? extends InvoiceReport> reportList = report.generateReport((reportFormatter = new QuickbooksReportFormat()).isFreightShownInvoiceReports(), reportFormatter.isAdminChargeShownInvoiceReports(), reportFormatter.isDiscountReportsShownInvoiceReports(), reportFormatter.isInvoiceDiscountNegative(), StockInvoice.getAccountableInvoiceTypes());
        StockInvoiceMYOBServicePurchasesMapping mapping = new StockInvoiceMYOBServicePurchasesMapping(reportList, reportFormatter);
        CSVExporter integrator = new CSVExporter(mapping);
        if (integrator.createExportFile(param.getFileName())) {
            return null;
        }
        return "create Export File fails ";
    }

    @Override
    protected String exportPayRoll(AccountingExportParams param) {
        return "Export PayRoll fails";
    }

    @Override
    protected String exportCustomers(AccountingExportParams param) {
        return "Export Customer fails";
    }

    @Override
    protected String exportAccountSetup(AccountingExportParams param) {
        return "Export Account Setup fails";
    }

    @Override
    protected String exportCustomerAccounts(AccountingExportParams param) {
        return "Export Account Accounts fails";
    }

    @Override
    public boolean isSetup() {
        return true;
    }

    @Override
    protected ReportFormat createReportFormat() {
        return new QuickbooksReportFormat();
    }

    @Override
    public List<AccountingExportFunction> getAccountingExportFunctions() {
        ArrayList<AccountingExportFunction> supportedList = new ArrayList<AccountingExportFunction>();
        supportedList.add(AccountingExportFunction.SALES_AND_TAKINGS);
        supportedList.add(AccountingExportFunction.INVOICES);
        return supportedList;
    }

    @Override
    public FinanceExportStyle getFinanceExportStyle() {
        return FinanceExportStyle.Quickbooks;
    }

    @Override
    public boolean supportsNegativeEntries() {
        return false;
    }
}

