/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance.quickbooks;

import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.integration.accounting.AccountNumberExportMethod;
import ordermate.database.integration.accounting.AccountingIntegrationConfig;
import ordermate.database.integration.accounting.formats.ReportFormat;
import ordermate.database.integration.accounting.reports.AccountingReport;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.database.integration.accounting.settings.QuickbooksConfiguration;

public class QuickbooksReportFormat
implements ReportFormat {
    @Override
    public String getGLCode(AccountingReport report) {
        if (AccountNumberExportMethod.ACCOUNT_NAME.equals((Object)QuickbooksConfiguration.getInstance().getAccountNumberExportMethod())) {
            GLAccount account = GLAccount.getGLAccountForGLCode(report.getGlAccountCode());
            return account == null ? "" : account.getName();
        }
        return report.getGlAccountCode();
    }

    @Override
    public boolean isEmptyLineBetweenSets() {
        return false;
    }

    @Override
    public String getPriceFormat() {
        return "0.00";
    }

    @Override
    public boolean isGLCodeUsedForAccountId() {
        return true;
    }

    @Override
    public String getJournalNumber(AccountingReport report) {
        return AccountingIntegrationConfig.getInstance().getExportPrefix() + report.getRecordID();
    }

    @Override
    public String getAccountName(AccountingReport report) {
        GLAccount account = GLAccount.getGLAccountForGLCode(report.getGlAccountCode());
        return account == null ? "" : account.getName();
    }

    @Override
    public boolean isExportZeroNetSales() {
        return true;
    }

    @Override
    public boolean isFreightShownInvoiceReports() {
        return true;
    }

    @Override
    public boolean isAdminChargeShownInvoiceReports() {
        return true;
    }

    @Override
    public boolean isDiscountReportsShownInvoiceReports() {
        return true;
    }

    @Override
    public boolean isExportToFile() {
        return true;
    }

    @Override
    public boolean isOutputReconciliationReports() {
        return true;
    }

    @Override
    public Price getNettAmountInc(Price amount, TaxCode tax) {
        double rate = 1.0 + tax.getRate();
        double doubleAmount = amount.doubleValue();
        return new Price(MathsUtils.roundDoubleToDecPlaces(doubleAmount /= rate, 2) * rate, 0.0);
    }

    @Override
    public String getMemo(AccountingReport report) {
        return report.getMemo();
    }

    @Override
    public String getExportFileExtension() {
        return ".csv";
    }

    @Override
    public boolean isInvoiceDiscountNegative() {
        return false;
    }
}

