/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance.taxcodes;

import java.util.HashMap;
import java.util.Map;
import ordermate.integration.finance.myob.mapping.FinanceExportStyle;

public abstract class AccountingIntegrationDefaultTaxCodes {
    protected Map<String, String> defaultCodeMap = new HashMap<String, String>();
    private final FinanceExportStyle exportType;

    public AccountingIntegrationDefaultTaxCodes(FinanceExportStyle exportType) {
        this.exportType = exportType;
        this.buildDefaultCodeMap();
    }

    public abstract void buildDefaultCodeMap();

    public FinanceExportStyle getExportType() {
        return this.exportType;
    }

    public String getAccExtIDForTaxCode(String taxCode) {
        return this.defaultCodeMap.containsKey(taxCode) ? this.defaultCodeMap.get(taxCode) : "";
    }
}

