/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance.taxcodes;

import ordermate.database.finance.tax.TaxCode;
import ordermate.integration.finance.myob.mapping.FinanceExportStyle;
import ordermate.integration.finance.taxcodes.AccountingIntegrationDefaultTaxCodes;
import ordermate.integration.finance.taxcodes.MYOBAccountingIntegrationDefaultTaxCodes;
import ordermate.integration.finance.taxcodes.QuickbooksAccountingIntegrationDefaultTaxCodes;
import ordermate.integration.finance.taxcodes.XeroAccountingIntegrationDefaultTaxCodes;

public class DefaultTaxCodesManager {
    public static void applyDefaultTaxCodes(FinanceExportStyle exportStyle) throws IllegalArgumentException {
        AccountingIntegrationDefaultTaxCodes defaultTaxCodes = DefaultTaxCodesManager.getAccountingIntegrationDefaultTaxCodes(exportStyle);
        for (TaxCode taxCode : TaxCode.getAllTaxCodes()) {
            String defCode = defaultTaxCodes.getAccExtIDForTaxCode(taxCode.getCode());
            if (defCode.isEmpty()) continue;
            taxCode.setExtAccID(defCode);
            taxCode.save();
        }
        TaxCode.clearCaches();
    }

    public static AccountingIntegrationDefaultTaxCodes getAccountingIntegrationDefaultTaxCodes(FinanceExportStyle exportStyle) throws IllegalArgumentException {
        if (FinanceExportStyle.MYOB.equals((Object)exportStyle)) {
            return new MYOBAccountingIntegrationDefaultTaxCodes();
        }
        if (FinanceExportStyle.Quickbooks.equals((Object)exportStyle)) {
            return new QuickbooksAccountingIntegrationDefaultTaxCodes();
        }
        if (FinanceExportStyle.Xero.equals((Object)exportStyle)) {
            return new XeroAccountingIntegrationDefaultTaxCodes();
        }
        throw new IllegalArgumentException("FinanceExportStyle of type: " + (Object)((Object)exportStyle) + " not suppported");
    }
}

