/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance.xero;

import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.oauth.OAuthProblemException;
import ordermate.OrderMate;
import ordermate.integration.jaxb.xero.ApiException;
import ordermate.integration.jaxb.xero.DataContractBase;
import ordermate.integration.jaxb.xero.ValidationError;
import ordermate.integration.jaxb.xero.Warning;

public class XeroApiException
extends Exception {
    private ApiException apiException;

    public XeroApiException(String message, OAuthProblemException oAuthProblemException) {
        super(message, (Throwable)oAuthProblemException);
        this.attemptToRetrieveXeroException(oAuthProblemException);
    }

    public ApiException getApiException() {
        return this.apiException;
    }

    private void attemptToRetrieveXeroException(OAuthProblemException oAuthProblemException) {
        StringBuilder oAuthProblemExceptionString = new StringBuilder("");
        Map params = oAuthProblemException.getParameters();
        for (String key : params.keySet()) {
            if (!key.contains("ApiException")) continue;
            Object o = params.get(key);
            oAuthProblemExceptionString.append(key);
            oAuthProblemExceptionString.append("=");
            oAuthProblemExceptionString.append(o);
        }
        if (oAuthProblemExceptionString.toString().isEmpty()) {
            return;
        }
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ApiException.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            JAXBElement element = unmarshaller.unmarshal((Source)new StreamSource(new StringReader(oAuthProblemExceptionString.toString())), ApiException.class);
            this.apiException = (ApiException)element.getValue();
        }
        catch (JAXBException ex) {
            OrderMate.LOG.error("Error occured unmarshalling Xero ApiException.");
            OrderMate.LOG.error((CharSequence)oAuthProblemExceptionString);
        }
    }

    @Override
    public String getLocalizedMessage() {
        if (this.apiException == null) {
            return "";
        }
        String NEW_LINE = "\n";
        StringBuilder sb = new StringBuilder();
        sb.append("Message: " + this.apiException.getMessage());
        sb.append("\n");
        sb.append("Error " + this.apiException.getErrorNumber() + ": " + this.apiException.getType());
        sb.append("\n");
        if (this.apiException.getElements() != null && this.apiException.getElements().getDataContractBase() != null) {
            List<DataContractBase> dataContractBases = this.apiException.getElements().getDataContractBase();
            for (DataContractBase dataContractBase : dataContractBases) {
                int i;
                sb.append("DataType: " + dataContractBase.getClass().getSimpleName());
                sb.append("\n");
                if (dataContractBase.getWarnings() != null && dataContractBase.getWarnings().getWarning() != null) {
                    List<Warning> warnings = dataContractBase.getWarnings().getWarning();
                    for (i = 0; i < warnings.size(); ++i) {
                        Warning warning = warnings.get(i);
                        sb.append("Warning " + (i + 1) + ": " + warning.getMessage());
                        sb.append("\n");
                    }
                }
                if (dataContractBase.getValidationErrors() == null || dataContractBase.getValidationErrors().getValidationError() == null) continue;
                List<ValidationError> validationErrors = dataContractBase.getValidationErrors().getValidationError();
                for (i = 0; i < validationErrors.size(); ++i) {
                    ValidationError validationError = validationErrors.get(i);
                    sb.append("Validation Error " + (i + 1) + ": " + validationError.getMessage());
                    sb.append("\n");
                }
            }
        }
        return sb.toString();
    }
}

