/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance.xero;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.web.HttpMethod;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXB;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.integration.accounting.AccountingIntegrationConfig;
import ordermate.database.integration.accounting.formats.ReportFormat;
import ordermate.database.integration.accounting.reports.AccountingDebtorReport;
import ordermate.database.integration.accounting.reports.AccountingFinanceReport;
import ordermate.database.integration.accounting.reports.AccountingReport;
import ordermate.database.integration.accounting.reports.AccountingSalesReport;
import ordermate.database.integration.accounting.settings.XeroConfiguration;
import ordermate.database.integration.webservice.WebserviceIntegrationConfig;
import ordermate.database.integration.webservice.WebserviceIntegrationType;
import ordermate.database.misc.OfficeMateEventLog;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.stock.StockInvoice;
import ordermate.integration.finance.AccountingExportFunction;
import ordermate.integration.finance.AccountingExportParams;
import ordermate.integration.finance.AccountingExporter;
import ordermate.integration.finance.myob.mapping.FinanceExportStyle;
import ordermate.integration.finance.xero.InvoiceSearchResult;
import ordermate.integration.finance.xero.InvoiceSearchStatus;
import ordermate.integration.finance.xero.XeroApiException;
import ordermate.integration.finance.xero.XeroReportFormat;
import ordermate.integration.finance.xero.XeroWebserviceHelper;
import ordermate.integration.finance.xero.XeroXMLManager;
import ordermate.integration.jaxb.xero.ArrayOfInvoice;
import ordermate.integration.jaxb.xero.ArrayOfLineItem;
import ordermate.integration.jaxb.xero.ArrayOfTrackingCategory;
import ordermate.integration.jaxb.xero.Contact;
import ordermate.integration.jaxb.xero.Invoice;
import ordermate.integration.jaxb.xero.InvoiceStatus;
import ordermate.integration.jaxb.xero.InvoiceType;
import ordermate.integration.jaxb.xero.LineItem;
import ordermate.integration.jaxb.xero.TrackingCategory;
import ordermate.reports.accounting.InvoiceDateMethod;
import ordermate.reports.accounting.InvoiceReport;

public class XeroExporter
extends AccountingExporter {
    private XeroWebserviceHelper xeroWebserviceHelper;
    private Map<String, Invoice> invoiceMap = new HashMap<String, Invoice>();
    private HashSet<String> handledInvoices = new HashSet();
    private boolean pushToFile = false;

    public XeroExporter(GuiHandler guiHandler, EventContext context) {
        super(guiHandler, context);
        try {
            this.xeroWebserviceHelper = new XeroWebserviceHelper(guiHandler);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error setting up the XeroWebserviceHelper.", (Throwable)ex);
        }
    }

    public void setPushToFile(boolean value) {
        this.pushToFile = value;
    }

    @Override
    protected String exportSalesAndTakings(AccountingExportParams param) {
        String reason = super.exportSalesAndTakings(param);
        if (reason != null) {
            return reason;
        }
        ArrayOfInvoice arrayOfInvoice = this.buildXeroSalesInvoices(this.getSalesAndFinanceReport().generateReport());
        OrderMate.LOG.info("The Array Of Invoices");
        OrderMate.LOG.info(XeroXMLManager.convertArrayOfInvoicesToXml(arrayOfInvoice));
        try {
            this.checkCustomerExists(AccountingIntegrationConfig.getInstance().getSalesInvCustomer());
        }
        catch (Exception ex) {
            OrderMate.LOG.info("Problem getting the customer existing, proceeding anyway", (Throwable)ex);
        }
        try {
            this.xeroWebserviceHelper.postInvoice(arrayOfInvoice);
        }
        catch (XeroApiException ex) {
            reason = "Export Failed - An error occurred while exporting the sales and takings data.XeroApiException";
            OrderMate.LOG.info(reason);
            OfficeMateEventLog.logAccountingExportEvent("Sales And Takings export failed.", param.getStartDate(), param.getEndDate(), this.getContext());
            if (this.getGuiHandler() != null) {
                this.getGuiHandler().displayErrorDialog("Export Failed", "An error occurred while exporting the sales and takings data.", ex.getLocalizedMessage());
            }
        }
        catch (Exception ex) {
            reason = "Export Failed - An error occurred while exporting the sales and takings data.";
            OrderMate.LOG.info(reason);
            OfficeMateEventLog.logAccountingExportEvent("Sales And Takings export failed.", param.getStartDate(), param.getEndDate(), this.getContext());
        }
        if (reason == null) {
            OfficeMateEventLog.logAccountingExportEvent("Sales And Takings successfully exported", param.getStartDate(), param.getEndDate(), this.getContext());
        }
        if (this.pushToFile) {
            try {
                File file = new File(param.getFileName());
                file.deleteOnExit();
                JAXB.marshal((Object)arrayOfInvoice, (File)file);
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Couldn't make Xero file", (Throwable)ex);
            }
        }
        return reason;
    }

    @Override
    protected String exportStockInvoices(AccountingExportParams param) {
        this.invoiceMap.clear();
        this.handledInvoices.clear();
        OrderMate.LOG.info("XeroExporter - Exporting Stock Invoices For: " + DateTimeUtils.getShortDateFormat().format(param.getStartDate()) + " to " + DateTimeUtils.getShortDateFormat().format(param.getEndDate()));
        String reason = null;
        if (!this.isSetup()) {
            reason = "XeroExporter is not currently setup correctly.  Stock Invoices will not be exported.";
            OrderMate.LOG.error(reason);
            if (this.getGuiHandler() != null) {
                this.getGuiHandler().displayOkDialog("Xero configuration is not currently setup correctly.", "Please check the Xero configuration before exporting.");
            }
        }
        boolean shouldExcludeExported = param.getInvoiceIDs().isEmpty();
        InvoiceReport report = new InvoiceReport(param.getStartDate(), param.getEndDate(), param.getInvoiceIDs());
        List<? extends InvoiceReport> reportList = report.generateReport(true, true, true, true, shouldExcludeExported, StockInvoice.getAccountableInvoiceTypes());
        if (reportList.isEmpty()) {
            OrderMate.LOG.info("No Invoices for the period to export.");
            if (this.getGuiHandler() != null) {
                this.getGuiHandler().displayOkDialog("No Invoice for period", "There were no Invoices for that date range.");
            }
            if (!InvoiceDateMethod.Creation.equals((Object)XeroConfiguration.getInstance().getInvoiceDateMethod())) {
                reason = "There were no Invoices for that date range.";
            }
        }
        Map<String, ArrayOfInvoice> map = this.buildXeroStockInvoices(reportList);
        ArrayOfInvoice arrayOfPostInvoices = new ArrayOfInvoice();
        ArrayOfInvoice arrayOfPutInvoices = new ArrayOfInvoice();
        for (Invoice invoice : this.invoiceMap.values()) {
            if (map.get("POST").getInvoice().contains(invoice)) {
                arrayOfPostInvoices.getInvoice().add(invoice);
                continue;
            }
            if (!map.get("PUT").getInvoice().contains(invoice)) continue;
            arrayOfPutInvoices.getInvoice().add(invoice);
        }
        boolean submitResult = false;
        if (arrayOfPostInvoices.getInvoice().size() > 0) {
            submitResult = this.submitInvoices(param, arrayOfPostInvoices, HttpMethod.POST);
        }
        if (arrayOfPutInvoices.getInvoice().size() > 0) {
            boolean bl = submitResult = submitResult || this.submitInvoices(param, arrayOfPutInvoices, HttpMethod.PUT);
        }
        if (!submitResult) {
            reason = "Something went wrong when submitting invoices";
        }
        return reason;
    }

    private boolean submitInvoices(AccountingExportParams param, ArrayOfInvoice arrayOfInvoice, HttpMethod method) {
        try {
            ArrayOfInvoice toMarkAsExported = new ArrayOfInvoice();
            this.xeroWebserviceHelper.submitInvoicesToXero(arrayOfInvoice, method);
            this.markAsExported(toMarkAsExported);
        }
        catch (XeroApiException ex) {
            OrderMate.LOG.info("Export Failed - An error occurred while exporting the invoice(s).");
            OfficeMateEventLog.logAccountingExportEvent("Invoices export failed.", param.getStartDate(), param.getEndDate(), this.getContext());
            if (this.getGuiHandler() != null) {
                this.getGuiHandler().displayErrorDialog("Export Failed", "An error occurred while exporting the invoice(s).", ex.getLocalizedMessage());
            }
            return false;
        }
        catch (Exception ex) {
            OrderMate.LOG.info("Export Failed - An error occurred while exporting the invoice(s).");
            OfficeMateEventLog.logAccountingExportEvent("Invoices export failed.", param.getStartDate(), param.getEndDate(), this.getContext());
            if (this.getGuiHandler() != null) {
                this.getGuiHandler().displayOkDialog("Export Failed", "An error occurred while exporting the invoice(s).");
            }
            return false;
        }
        OfficeMateEventLog.logAccountingExportEvent("Invoices successfully exported", param.getStartDate(), param.getEndDate(), this.getContext());
        return true;
    }

    private void markAsExported(ArrayOfInvoice toMarkAsExported) {
        for (Invoice invoice : toMarkAsExported.getInvoice()) {
            StockInvoice stockInvoice = StockInvoice.getStockInvoiceForNumber(invoice.getInvoiceNumber());
            if (stockInvoice == null) continue;
            stockInvoice.setDateExported(Calendar.getInstance().getTime());
            stockInvoice.save();
        }
    }

    private List<AccountingReport> modifySalesReportMultipleTax(List<AccountingReport> allReports) {
        for (int i = 0; i < allReports.size(); ++i) {
            for (int ii = 0; ii < i; ++ii) {
                if (!allReports.get(ii).getGlAccountCode().equals(allReports.get(i).getGlAccountCode()) || !allReports.get(ii).getTotal().equals(allReports.get(i).getTotal()) || !allReports.get(ii).getAllocationMemo().equals(allReports.get(i).getAllocationMemo()) || !allReports.get(ii).getTaxCode().getExtAccID().equals(allReports.get(i).getTaxCode().getExtAccID()) || !(allReports.get(ii) instanceof AccountingSalesReport) || !(allReports.get(i) instanceof AccountingSalesReport)) continue;
                ((AccountingSalesReport)allReports.get(i)).setTaxAmount(((AccountingSalesReport)allReports.get(i)).getTaxAmount().add(((AccountingSalesReport)allReports.get(ii)).getTaxAmount()));
                allReports.remove(ii);
                i = 0;
                ii = 0;
            }
        }
        return allReports;
    }

    private ArrayOfInvoice buildXeroSalesInvoices(List<AccountingReport> allReports) {
        ExperimentalFeature feature = ExperimentalFeature.find("Merge Reports Multiple Tax");
        if (feature != null && feature.getBooleanValue(false).booleanValue()) {
            allReports = this.modifySalesReportMultipleTax(allReports);
        }
        for (AccountingReport report : allReports) {
            this.addFinanceReportEntry(report);
        }
        ArrayOfInvoice xeroInvoiceArray = new ArrayOfInvoice();
        xeroInvoiceArray.getInvoice().addAll(this.invoiceMap.values());
        return xeroInvoiceArray;
    }

    protected Map<String, ArrayOfInvoice> buildXeroStockInvoices(List<? extends InvoiceReport> reportList) {
        LinkedHashMap<String, ArrayOfInvoice> httpMethodInvoiceMap = new LinkedHashMap<String, ArrayOfInvoice>();
        httpMethodInvoiceMap.put("PUT", new ArrayOfInvoice());
        httpMethodInvoiceMap.put("POST", new ArrayOfInvoice());
        for (InvoiceReport invoiceReport : reportList) {
            this.addStockInvoiceLineItemToInvoice(httpMethodInvoiceMap, invoiceReport);
        }
        return httpMethodInvoiceMap;
    }

    protected InvoiceSearchResult findInvoiceFromXero(Map<String, ArrayOfInvoice> httpMethodInvoiceMap, InvoiceReport invoiceReport) {
        Invoice newInvoice = null;
        try {
            String invoiceId = invoiceReport.getSupplierInvoiceNumber();
            String supplierName = invoiceReport.getSupplierName();
            newInvoice = this.getNewInvoice(invoiceId, invoiceReport.getInvoiceDate(), InvoiceType.ACCPAY, supplierName, "POS Stock Invoice");
            ArrayOfInvoice arrayOfInvoice = this.xeroWebserviceHelper.getInvoicesFor(invoiceId);
            if (arrayOfInvoice == null || arrayOfInvoice.getInvoice().size() == 0) {
                return new InvoiceSearchResult(InvoiceSearchStatus.INVOICE_POST_METHOD, newInvoice);
            }
            ArrayList<Invoice> sameSupplierInvoices = new ArrayList<Invoice>();
            for (Invoice invoice : arrayOfInvoice.getInvoice()) {
                if (!invoice.getContact().getName().equals(supplierName)) continue;
                sameSupplierInvoices.add(invoice);
            }
            if (sameSupplierInvoices.size() == 0) {
                return new InvoiceSearchResult(InvoiceSearchStatus.INVOICE_PUT_METHOD, newInvoice);
            }
            HashMap<InvoiceStatus, ArrayList<Invoice>> statusInvoiceMap = new HashMap<InvoiceStatus, ArrayList<Invoice>>();
            for (Invoice invoice : sameSupplierInvoices) {
                if (statusInvoiceMap.containsKey((Object)invoice.getStatus())) {
                    ((List)statusInvoiceMap.get((Object)invoice.getStatus())).add(invoice);
                    continue;
                }
                statusInvoiceMap.put(invoice.getStatus(), new ArrayList<Invoice>(Arrays.asList(invoice)));
            }
            if (statusInvoiceMap.containsKey((Object)InvoiceStatus.AUTHORISED)) {
                return new InvoiceSearchResult(InvoiceSearchStatus.INVOICE_ALREADY_FINALIZED, (Invoice)((List)statusInvoiceMap.get((Object)InvoiceStatus.AUTHORISED)).get(0));
            }
            if (statusInvoiceMap.containsKey((Object)InvoiceStatus.PAID)) {
                return new InvoiceSearchResult(InvoiceSearchStatus.INVOICE_ALREADY_FINALIZED, (Invoice)((List)statusInvoiceMap.get((Object)InvoiceStatus.PAID)).get(0));
            }
            if (statusInvoiceMap.containsKey((Object)InvoiceStatus.DRAFT)) {
                Invoice invoice = (Invoice)((List)statusInvoiceMap.get((Object)InvoiceStatus.DRAFT)).get(0);
                newInvoice.setInvoiceID(invoice.getInvoiceID());
                return new InvoiceSearchResult(InvoiceSearchStatus.INVOICE_POST_METHOD, newInvoice);
            }
            if (statusInvoiceMap.containsKey((Object)InvoiceStatus.SUBMITTED)) {
                Invoice invoice = (Invoice)((List)statusInvoiceMap.get((Object)InvoiceStatus.SUBMITTED)).get(0);
                newInvoice.setInvoiceID(invoice.getInvoiceID());
                return new InvoiceSearchResult(InvoiceSearchStatus.INVOICE_POST_METHOD, newInvoice);
            }
            if (statusInvoiceMap.containsKey((Object)InvoiceStatus.DELETED) || statusInvoiceMap.containsKey((Object)InvoiceStatus.VOIDED)) {
                return new InvoiceSearchResult(InvoiceSearchStatus.INVOICE_PUT_METHOD, newInvoice);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Cannot determine Xero Invoice status", (Throwable)ex);
        }
        return new InvoiceSearchResult(InvoiceSearchStatus.INVOICE_POST_METHOD, newInvoice);
    }

    private void addStockInvoiceLineItemToInvoice(Map<String, ArrayOfInvoice> httpMethodInvoiceMap, InvoiceReport invoiceReport) {
        String invoiceId = invoiceReport.getSupplierInvoiceNumber();
        Invoice invoice = this.invoiceMap.get(invoiceId);
        if (invoice == null) {
            InvoiceSearchResult searchResult = this.findInvoiceFromXero(httpMethodInvoiceMap, invoiceReport);
            invoice = searchResult.getInvoice();
            if (InvoiceSearchStatus.INVOICE_ALREADY_FINALIZED.equals((Object)searchResult.getSearchStatus()) && !this.handledInvoices.contains(invoiceId)) {
                String message = "Invoice Number : " + invoice.getInvoiceNumber() + " is already finalized in Xero.  Please modify the invoice number";
                String errorMessage = "Invoice Number : " + invoice.getInvoiceNumber() + " with Supplier " + invoice.getContact().getName() + " is already finalized for a total of " + invoice.getTotal();
                OrderMate.LOG.warn(errorMessage);
                TerminalEventLog.getInst().logInvoiceSyncEvent(invoice, this.getContext());
                this.handledInvoices.add(invoiceId);
                if (this.getGuiHandler() != null) {
                    this.getGuiHandler().displayErrorDialog("Invoice Not Uploaded", message, errorMessage);
                }
                return;
            }
            this.invoiceMap.put(invoiceId, invoice);
            switch (searchResult.getSearchStatus()) {
                case INVOICE_PUT_METHOD: {
                    httpMethodInvoiceMap.get("PUT").getInvoice().add(invoice);
                    break;
                }
                default: {
                    httpMethodInvoiceMap.get("POST").getInvoice().add(invoice);
                }
            }
        }
        LineItem lineItem = new LineItem();
        BigDecimal amount = invoiceReport.getItemAmount().toBigDecimal();
        lineItem.setUnitAmount(amount);
        lineItem.setAccountCode(invoiceReport.getGlAccountCode());
        lineItem.setTaxType(invoiceReport.getTaxCode().getExtAccID());
        lineItem.setQuantity(BigDecimal.ONE);
        lineItem.setDescription(invoiceReport.getDescription());
        lineItem.setLineAmount(amount);
        lineItem.setTaxAmount(invoiceReport.getItemTax().toBigDecimal());
        this.setTrackingCategory(lineItem);
        invoice.getLineItems().getLineItem().add(lineItem);
    }

    private void setTrackingCategory(LineItem lineItem) {
        XeroConfiguration xeroConfiguration = XeroConfiguration.getInstance();
        if (xeroConfiguration.hasValues()) {
            ArrayOfTrackingCategory array = new ArrayOfTrackingCategory();
            String categoryname = xeroConfiguration.getTrackingCategoryName();
            String categoryOption = xeroConfiguration.getTrackingCategoryOption();
            TrackingCategory newTrackingCategory = new TrackingCategory();
            newTrackingCategory.setOption(categoryOption);
            newTrackingCategory.setName(categoryname);
            array.getTrackingCategory().add(newTrackingCategory);
            lineItem.setTracking(array);
        }
    }

    private void setContactType(Contact contact, InvoiceType invoiceType) {
        switch (invoiceType) {
            case ACCPAY: {
                contact.setIsSupplier(true);
            }
        }
    }

    private Invoice getNewInvoice(String invoiceId, Date invDate, InvoiceType invType, String contactName, String reference) {
        Invoice invoice = new Invoice();
        Contact invoiceContact = new Contact();
        invoiceContact.setName(contactName);
        this.setContactType(invoiceContact, invType);
        invoice.setInvoiceNumber(invoiceId);
        invoice.setContact(invoiceContact);
        invoice.setType(invType);
        invoice.setStatus(InvoiceStatus.DRAFT);
        invoice.setReference(reference);
        try {
            Calendar invCalendar = DateTimeUtils.getCalendar(invDate);
            invoice.setDate(invCalendar);
            if (AccountingIntegrationConfig.getInstance().isDefaultDueDate()) {
                invoice.setDueDate(invCalendar);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error setting the invoice date.", (Throwable)ex);
        }
        ArrayOfLineItem arrayOfLineItems = new ArrayOfLineItem();
        invoice.setLineItems(arrayOfLineItems);
        invoice.getLineAmountTypes().add("Inclusive");
        return invoice;
    }

    private void checkCustomerExists(String custName) throws Exception {
        if (this.xeroWebserviceHelper.getContactByName(custName) == null) {
            Contact posContact = new Contact();
            posContact.setName(custName);
            this.xeroWebserviceHelper.postContact(posContact);
        }
    }

    @Override
    public boolean isSetup() {
        boolean allGood = FinanceExportStyle.Xero.equals((Object)AccountingIntegrationConfig.getInstance().getType()) && AccountingIntegrationConfig.getInstance().getWebserviceConfig() != null;
        WebserviceIntegrationConfig webConfig = AccountingIntegrationConfig.getInstance().getWebserviceConfig();
        allGood = WebserviceIntegrationType.OAuth.equals((Object)webConfig.getWebserviceType()) ? (allGood &= this.checkPropertyNotNullOrEmpty(webConfig.getUrl()) && this.checkPropertyNotNullOrEmpty(webConfig.getSecretKey()) && this.checkPropertyNotNullOrEmpty(webConfig.getPrivateKey()) && this.checkPropertyNotNullOrEmpty(webConfig.getConsumerKey())) : (WebserviceIntegrationType.OAuth2.equals((Object)webConfig.getWebserviceType()) ? (allGood &= this.checkPropertyNotNullOrEmpty(webConfig.getAccessToken()) && this.checkPropertyNotNullOrEmpty(webConfig.getClientId())) : false);
        return allGood;
    }

    XeroWebserviceHelper getXeroWebserviceHelper() {
        return this.xeroWebserviceHelper;
    }

    private void addFinanceReportEntry(AccountingReport report) {
        if (report instanceof AccountingFinanceReport) {
            this.addFinanceReport((AccountingFinanceReport)report);
        } else if (report instanceof AccountingSalesReport) {
            this.addSalesReport((AccountingSalesReport)report);
        } else if (report instanceof AccountingDebtorReport) {
            this.addDebtorReport((AccountingDebtorReport)report);
        } else {
            this.addUnknownReport(report);
        }
    }

    private void addFinanceReport(AccountingFinanceReport report) {
        String invoiceId = this.getReportFormat().getJournalNumber(report);
        Invoice invoice = this.invoiceMap.get(invoiceId);
        if (invoice == null) {
            invoice = this.getNewInvoice(invoiceId, report.getDate(), InvoiceType.ACCREC, AccountingIntegrationConfig.getInstance().getSalesInvCustomer(), "POS Sales");
            this.invoiceMap.put(invoiceId, invoice);
        }
        LineItem lineItem = new LineItem();
        BigDecimal amount = report.getAmount() != null ? report.getAmount().negate().toBigDecimal() : report.getAmountNeg().negate().toBigDecimal();
        lineItem.setUnitAmount(amount);
        lineItem.setAccountCode(this.getReportFormat().getGLCode(report));
        if (!AccountingIntegrationConfig.getInstance().isExcludeTaxCodes()) {
            lineItem.setTaxType(report.getTaxCode().getExtAccID());
        }
        lineItem.setQuantity(BigDecimal.ONE);
        lineItem.setDescription(report.getAllocationMemo());
        lineItem.setLineAmount(amount);
        lineItem.setTaxAmount(report.getTaxAmount().negate().toBigDecimal());
        this.setTrackingCategory(lineItem);
        invoice.getLineItems().getLineItem().add(lineItem);
    }

    private void addSalesReport(AccountingSalesReport report) {
        String invoiceId = this.getReportFormat().getJournalNumber(report);
        Invoice invoice = this.invoiceMap.get(invoiceId);
        if (invoice == null) {
            invoice = this.getNewInvoice(invoiceId, report.getDate(), InvoiceType.ACCREC, AccountingIntegrationConfig.getInstance().getSalesInvCustomer(), "POS Sales");
            this.invoiceMap.put(invoiceId, invoice);
        }
        LineItem lineItem = new LineItem();
        BigDecimal amount = report.getNettSales() != null ? report.getNettSales().toBigDecimal() : report.getNettSalesNeg().toBigDecimal();
        lineItem.setUnitAmount(amount);
        lineItem.setAccountCode(this.getReportFormat().getGLCode(report));
        if (!AccountingIntegrationConfig.getInstance().isExcludeTaxCodes()) {
            lineItem.setTaxType(report.getTaxCode().getExtAccID());
        }
        lineItem.setQuantity(BigDecimal.ONE);
        lineItem.setDescription(report.getAllocationMemo());
        lineItem.setLineAmount(amount);
        lineItem.setTaxAmount(report.getTaxAmount().toBigDecimal());
        this.setTrackingCategory(lineItem);
        invoice.getLineItems().getLineItem().add(lineItem);
    }

    private void addDebtorReport(AccountingDebtorReport report) {
    }

    @Override
    protected ReportFormat createReportFormat() {
        return new XeroReportFormat();
    }

    @Override
    public List<AccountingExportFunction> getAccountingExportFunctions() {
        ArrayList<AccountingExportFunction> supportedList = new ArrayList<AccountingExportFunction>();
        supportedList.add(AccountingExportFunction.SALES_AND_TAKINGS);
        supportedList.add(AccountingExportFunction.INVOICES);
        return supportedList;
    }

    @Override
    protected String exportPayRoll(AccountingExportParams param) {
        throw new UnsupportedOperationException("Exporting of PayRoll data not currently supported.");
    }

    @Override
    protected String exportCustomers(AccountingExportParams param) {
        throw new UnsupportedOperationException("Exporting of Customer data not currently supported.");
    }

    @Override
    protected String exportAccountSetup(AccountingExportParams param) {
        throw new UnsupportedOperationException("Exporting of Account Setup data not currently supported.");
    }

    @Override
    protected String exportCustomerAccounts(AccountingExportParams param) {
        throw new UnsupportedOperationException("Exporting of Customer Account data not currently supported.");
    }

    @Override
    public FinanceExportStyle getFinanceExportStyle() {
        return FinanceExportStyle.Xero;
    }
}

