/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance.xero;

import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.net.ssl.SSLContext;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.client.httpclient4.HttpClient4;
import net.oauth.client.httpclient4.HttpClientPool;
import net.oauth.http.HttpClient;
import ordermate.OrderMate;
import ordermate.database.integration.accounting.AccountingIntegrationConfig;
import ordermate.integration.webservice.OAuthHelper;
import ordermate.integration.webservice.OAuthMapBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.impl.client.HttpClients;

public class XeroOAuthHelper
extends OAuthHelper {
    private static final HttpClientPool XERO_HTTP_CLIENT_POOL = new XeroHttpClientPool();
    private static final String[] DEFAULT_VALID_KEYS = new String[]{"consumerKey", "consumerSecret"};

    public XeroOAuthHelper() {
        this(new OAuthMapBuilder(DEFAULT_VALID_KEYS).addKey(AccountingIntegrationConfig.getInstance().getWebserviceConfig() != null ? AccountingIntegrationConfig.getInstance().getWebserviceConfig().getConsumerKey() : "").addSecret(AccountingIntegrationConfig.getInstance().getWebserviceConfig() != null ? AccountingIntegrationConfig.getInstance().getWebserviceConfig().getSecretKey() : "").addPrivateKey(AccountingIntegrationConfig.getInstance().getWebserviceConfig() != null ? AccountingIntegrationConfig.getInstance().getWebserviceConfig().getPrivateKey() : ""));
    }

    public XeroOAuthHelper(OAuthMapBuilder builder) {
        super(builder);
        this.getRawMap().put("accessToken", this.getRawMap().get("consumerKey"));
    }

    @Override
    protected void addAdditionalParametersToConsumer(OAuthConsumer consumer, Map<String, String> props) {
    }

    @Override
    protected void addAdditionalParametersToRequestParams(Map<String, String> requestMap, Map<String, String> props) {
    }

    @Override
    protected OAuthAccessor createOAuthAccessor() {
        String consumerKey = this.getRawMap().get("consumerKey");
        String consumerSecret = this.getRawMap().get("consumerSecret");
        OAuthConsumer consumer = new OAuthConsumer(null, consumerKey, null, null);
        consumer.setProperty("RSA-SHA1.PrivateKey", (Object)this.getRawMap().get("privateKey"));
        consumer.setProperty("oauth_signature_method", (Object)"RSA-SHA1");
        OAuthAccessor accessor = new OAuthAccessor(consumer);
        accessor.accessToken = consumerKey;
        accessor.tokenSecret = consumerSecret;
        return accessor;
    }

    @Override
    protected HttpClient getHttpClient() {
        return new HttpClient4(XERO_HTTP_CLIENT_POOL);
    }

    private static class XeroHttpClientPool
    implements HttpClientPool {
        private final String[] SUPPORTED_PROTOCOLS = new String[]{"TLSv1.1", "TLSv1.2"};

        private XeroHttpClientPool() {
        }

        public org.apache.http.client.HttpClient getHttpClient(URL server) {
            return this.getXeroHttpClient();
        }

        private org.apache.http.client.HttpClient getXeroHttpClient() {
            SSLContext sslContext = null;
            try {
                sslContext = SSLContexts.custom().useTLS().build();
            }
            catch (NoSuchAlgorithmException e) {
                OrderMate.LOG.error("Unable to create XERO SSL context in http client due to the non-existent algorithm", (Throwable)e);
            }
            catch (KeyManagementException e) {
                OrderMate.LOG.error("Unable to create XERO SSL context in http client", (Throwable)e);
            }
            SSLConnectionSocketFactory f = new SSLConnectionSocketFactory(sslContext, this.SUPPORTED_PROTOCOLS, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)f).build();
        }
    }
}

