/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance.xero;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.web.HttpMethod;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import ordermate.OrderMate;
import ordermate.database.integration.accounting.AccountingIntegrationConfig;
import ordermate.database.integration.webservice.WebserviceIntegrationConfig;
import ordermate.database.integration.webservice.WebserviceIntegrationType;
import ordermate.integration.finance.xero.XeroApiException;
import ordermate.integration.finance.xero.XeroOAuthHelper;
import ordermate.integration.finance.xero.XeroXMLManager;
import ordermate.integration.jaxb.xero.ArrayOfContact;
import ordermate.integration.jaxb.xero.ArrayOfInvoice;
import ordermate.integration.jaxb.xero.Contact;
import ordermate.integration.jaxb.xero.Invoice;
import ordermate.integration.jaxb.xero.TrackingCategory;
import ordermate.integration.oauth.OAuth2Client;
import ordermate.integration.oauth.XeroOAuth2Handler;
import ordermate.integration.webservice.OAuthHelper;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class XeroWebserviceHelper {
    private OAuthHelper xeroOAuthHelper;
    private static final String QUOTE_SPECIAL_CHAR = "%22";
    private static final int READ_TIMEOUT = 60000;
    private static final int MAX_INVOICES_SEND = 20;
    private static final String WEB_METHOD_INVOICES = "Invoices";
    private static final String WEB_METHOD_CONTACTS = "Contacts";
    private static final String WEB_METHOD_REPORTS = "Reports";
    private static final String WEB_METHOD_PAYMENTS = "Payments";
    private Map<String, TrackingCategory> trackingCategoryMap = new HashMap<String, TrackingCategory>();
    private GuiHandler gui;

    public XeroWebserviceHelper(GuiHandler guiHandler) {
        this.gui = guiHandler;
        this.xeroOAuthHelper = new XeroOAuthHelper();
        this.xeroOAuthHelper.setReadTimeout(60000);
    }

    private InputStream sendRequest(HttpMethod httpMethod, String endPointUrl, String payload, String mediaType) throws IOException, OAuthException, URISyntaxException {
        WebserviceIntegrationConfig webConfig = AccountingIntegrationConfig.getInstance().getWebserviceConfig();
        if (WebserviceIntegrationType.OAuth2.equals((Object)webConfig.getWebserviceType())) {
            OAuth2Client client = new OAuth2Client(webConfig, new XeroOAuth2Handler(), this.gui);
            WebResource resource = client.createAPIResource(endPointUrl.toString());
            if (resource == null) {
                return null;
            }
            ClientResponse response = payload != null ? (ClientResponse)((WebResource.Builder)resource.accept(new String[]{mediaType}).type(mediaType)).method(httpMethod.name(), ClientResponse.class, (Object)payload) : (ClientResponse)((WebResource.Builder)resource.accept(new String[]{mediaType}).type(mediaType)).method(httpMethod.name(), ClientResponse.class);
            if (response != null) {
                String responseString = StringUtils.readFromStream(response.getEntityInputStream(), -1);
                Collection contentTypes = (Collection)response.getHeaders().get((Object)"Content-Type");
                String contentType = "application/xml";
                if (contentTypes != null && contentTypes.size() > 0) {
                    contentType = (String)contentTypes.iterator().next();
                }
                ByteArrayInputStream bin = new ByteArrayInputStream(responseString.getBytes());
                if (response.getStatus() / 100 != 2) {
                    String errorMessage = this.getErrorFromResponse(responseString, contentType, response.getStatus());
                    this.gui.displayErrorDialog("Xero unsuccessful", "Response from Xero indicated a problem", errorMessage);
                    OrderMate.LOG.warn("Problem with Xero " + endPointUrl + " status:" + response.getStatus() + " Error : " + errorMessage);
                    throw new IOException("Problem with Xero, status:" + response.getStatus());
                }
                OrderMate.LOG.warn("Xero successful " + endPointUrl + " status:" + response.getStatus());
                return bin;
            }
        } else {
            OAuthMessage response = this.xeroOAuthHelper.prepareRequest(httpMethod.name(), endPointUrl, payload, mediaType);
            if (response != null) {
                return response.getBodyAsStream();
            }
        }
        if (this.gui != null) {
            this.gui.displayOkDialog("Xero unsuccessful", "Received no response from Xero");
        }
        return null;
    }

    public String getErrorFromResponse(String responseString, String contentType, int responseStatus) {
        StringBuilder sb = new StringBuilder();
        if ("application/xml".equals(contentType)) {
            if (responseStatus == 400) {
                sb.append(this.getXMLResponse(responseString));
            } else if (responseStatus == 401) {
                sb.append("Invalid authorization credentials");
            } else if (responseStatus == 403) {
                sb.append("User doesn't have permission to access the resource.");
            } else if (responseStatus == 404) {
                sb.append("The resource you have specified cannot be found");
            } else if (responseStatus == 500) {
                sb.append("An unhandled error with the Xero API. Contact the Xero API team if problems persist");
            } else if (responseStatus == 503) {
                sb.append("The API rate limit for your organisation/application pairing has been exceeded.");
            }
        } else {
            sb.append(responseString);
        }
        return sb.toString();
    }

    public String getXMLResponse(String responseString) {
        String APIEXCEPTION = "ApiException";
        StringBuilder sb = new StringBuilder();
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(responseString.getBytes());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(bin);
            String rootTagName = doc.getDocumentElement().getTagName();
            if ("ApiException".equals(rootTagName)) {
                NodeList messageList = doc.getElementsByTagName("Message");
                for (int i = 0; i < messageList.getLength(); ++i) {
                    sb.append(messageList.item(i).getFirstChild().getNodeValue());
                    sb.append("\n");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sb.toString();
    }

    private String getInvoiceSearchURL(String invoiceNumber) throws Exception {
        StringBuilder sb = new StringBuilder(AccountingIntegrationConfig.getInstance().getWebserviceConfig().getUrl());
        sb.append(WEB_METHOD_INVOICES).append("?where=").append("(InvoiceNumber%3d%3d").append(QUOTE_SPECIAL_CHAR).append(invoiceNumber).append(QUOTE_SPECIAL_CHAR).append(")");
        return sb.toString();
    }

    public ArrayOfInvoice getInvoicesFor(String invoiceNumber) throws Exception {
        String searchURL = this.getInvoiceSearchURL(invoiceNumber);
        InputStream input = this.sendRequest(HttpMethod.GET, searchURL, null, "application/xml");
        if (input != null) {
            return XeroXMLManager.convertXMLToArrayOfInvoices(input);
        }
        throw new IllegalStateException("Cannot contact Xero, please see logs");
    }

    public boolean testConnection() throws Exception {
        String searchURL = this.getInvoiceSearchURL("XXX");
        InputStream input = this.sendRequest(HttpMethod.GET, searchURL, null, "application/xml");
        return input != null;
    }

    public Contact getContactByName(String name) throws Exception {
        StringBuilder endPointUrl = new StringBuilder(AccountingIntegrationConfig.getInstance().getWebserviceConfig().getUrl()).append(WEB_METHOD_CONTACTS).append("?where=Name==").append(QUOTE_SPECIAL_CHAR).append(URLEncoder.encode(name, "UTF-8")).append(QUOTE_SPECIAL_CHAR);
        InputStream input = this.sendRequest(HttpMethod.GET, endPointUrl.toString(), null, "application/xml");
        if (input != null) {
            ArrayOfContact contacts = XeroXMLManager.convertXMLToArrayOfContacts(input);
            input.close();
            if (contacts != null && !contacts.getContact().isEmpty()) {
                return contacts.getContact().get(0);
            }
        } else {
            throw new IllegalStateException("Cannot contact Xero, please see logs.");
        }
        return null;
    }

    public void postContact(Contact newContact) throws Exception {
        try {
            StringBuilder endPointUrl = new StringBuilder(AccountingIntegrationConfig.getInstance().getWebserviceConfig().getUrl()).append(WEB_METHOD_CONTACTS);
            ArrayOfContact arrayOfContact = new ArrayOfContact();
            List<Contact> contacts = arrayOfContact.getContact();
            contacts.add(newContact);
            this.sendRequest(HttpMethod.POST, endPointUrl.toString(), XeroXMLManager.convertArrayOfContactsToXml(arrayOfContact), "application/xml");
        }
        catch (OAuthProblemException oAuthEx) {
            XeroApiException ex = new XeroApiException("Error while attempting to post a Contact.", oAuthEx);
            OrderMate.LOG.error("Oauth problem occurred in Xero accounting export", ex.getCause());
            throw ex;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error occured posting contacts.", (Throwable)ex);
            throw ex;
        }
    }

    public void postInvoice(Invoice invoice) throws Exception {
        ArrayOfInvoice arrayOfInvoice = new ArrayOfInvoice();
        List<Invoice> invoices = arrayOfInvoice.getInvoice();
        invoices.add(invoice);
        this.postInvoice(arrayOfInvoice);
    }

    public ArrayOfInvoice submitInvoicesToXero(ArrayOfInvoice invoiceArray, HttpMethod httpMethod) throws Exception {
        ArrayOfInvoice toMarkAsExported = new ArrayOfInvoice();
        List<List<Invoice>> splitSubLists = this.splitIntoSmallerLists(invoiceArray.getInvoice(), 20);
        ArrayOfInvoice tmpArrayOfInvoice = new ArrayOfInvoice();
        for (List<Invoice> subList : splitSubLists) {
            tmpArrayOfInvoice.getInvoice().clear();
            tmpArrayOfInvoice.getInvoice().addAll(subList);
            try {
                StringBuilder endPointUrl = new StringBuilder(AccountingIntegrationConfig.getInstance().getWebserviceConfig().getUrl()).append(WEB_METHOD_INVOICES);
                InputStream stream = this.sendRequest(httpMethod, endPointUrl.toString(), XeroXMLManager.convertArrayOfInvoicesToXml(tmpArrayOfInvoice), "application/xml");
                if (stream != null) {
                    OrderMate.LOG.info("Received response:" + StringUtils.readFromStream(stream, -1));
                    toMarkAsExported.getInvoice().addAll(subList);
                    continue;
                }
                OrderMate.LOG.warn("No Xero response received");
            }
            catch (OAuthProblemException oAuthEx) {
                XeroApiException ex = new XeroApiException("Error while attempting to post Invoice(s).", oAuthEx);
                OrderMate.LOG.error("Oauth problem occurred in Xero invoices export", ex.getCause());
                throw ex;
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Error occured posting an Invoice.", (Throwable)ex);
                throw ex;
            }
        }
        return toMarkAsExported;
    }

    public ArrayOfInvoice postInvoice(ArrayOfInvoice invoiceArray) throws Exception {
        return this.submitInvoicesToXero(invoiceArray, HttpMethod.POST);
    }

    public ArrayOfInvoice putInvoice(ArrayOfInvoice invoiceArray) throws Exception {
        return this.submitInvoicesToXero(invoiceArray, HttpMethod.PUT);
    }

    private <T> List<List<T>> splitIntoSmallerLists(List<T> srcList, int subListLength) {
        ArrayList<List<T>> subLists = new ArrayList<List<T>>();
        int POS_NUM_LISTS = srcList.size();
        for (int i = 0; i < POS_NUM_LISTS; i += subListLength) {
            subLists.add(new ArrayList<T>(srcList.subList(i, Math.min(POS_NUM_LISTS, i + subListLength))));
        }
        return subLists;
    }

    void setXeroOAuthHelper(OAuthHelper xeroOAuthHelper) {
        this.xeroOAuthHelper = xeroOAuthHelper;
    }
}

