/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.finance.xero;

import au.com.ordermate.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import ordermate.OrderMate;
import ordermate.integration.jaxb.xero.ArrayOfContact;
import ordermate.integration.jaxb.xero.ArrayOfInvoice;
import ordermate.integration.jaxb.xero.ObjectFactory;
import ordermate.integration.jaxb.xero.ResponseType;

class XeroXMLManager {
    XeroXMLManager() {
    }

    public static ArrayOfInvoice convertXMLToArrayOfInvoices(InputStream invoiceStream) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ResponseType.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            JAXBElement element = unmarshaller.unmarshal((Source)new StreamSource(invoiceStream), ResponseType.class);
            return ((ResponseType)element.getValue()).getInvoices();
        }
        catch (JAXBException ex) {
            OrderMate.LOG.error("XeroXMLManager.convertXMLToArrayOfInvoices error while converting InputStream.", (Throwable)ex);
            return null;
        }
    }

    public static ArrayOfContact convertXMLToArrayOfContacts(InputStream invoiceStream) {
        String input = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ResponseType.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            input = StringUtils.readFromStream(invoiceStream, -1);
            ByteArrayInputStream bin = new ByteArrayInputStream(input.getBytes());
            JAXBElement element = unmarshaller.unmarshal((Source)new StreamSource(bin), ResponseType.class);
            OrderMate.LOG.info("Got Xero contacts response:" + input);
            return ((ResponseType)element.getValue()).getContacts();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("XeroXMLManager.convertXMLToArrayOfContacts error while converting InputStream. Response was " + input, (Throwable)ex);
            return null;
        }
    }

    public static String convertArrayOfContactsToXml(ArrayOfContact arrayOfContacts) {
        String contactsString = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ResponseType.class});
            Marshaller marshaller = context.createMarshaller();
            ObjectFactory factory = new ObjectFactory();
            JAXBElement<ArrayOfContact> element = factory.createContacts(arrayOfContacts);
            StringWriter stringWriter = new StringWriter();
            marshaller.marshal(element, (Writer)stringWriter);
            contactsString = stringWriter.toString();
        }
        catch (JAXBException ex) {
            OrderMate.LOG.error("XeroXMLManager.convertArrayOfContactsToXml error while converting InputStream.", (Throwable)ex);
        }
        return contactsString;
    }

    public static String convertArrayOfInvoicesToXml(ArrayOfInvoice arrayOfInvoices) {
        String invoicesString = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ResponseType.class});
            Marshaller marshaller = context.createMarshaller();
            ObjectFactory factory = new ObjectFactory();
            JAXBElement<ArrayOfInvoice> element = factory.createInvoices(arrayOfInvoices);
            StringWriter stringWriter = new StringWriter();
            marshaller.marshal(element, (Writer)stringWriter);
            invoicesString = stringWriter.toString();
        }
        catch (JAXBException ex) {
            OrderMate.LOG.error("XeroXMLManager.convertArrayOfInvoicesToXml error while converting InputStream.", (Throwable)ex);
        }
        return invoicesString;
    }
}

