/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.humpy;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import com.sun.jersey.api.client.WebResource;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.database.integration.webservice.WebserviceIntegrationConfig;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.integration.cloudback.CloudIntegrationUtil;
import ordermate.integration.webservice.RestHelper;

public class HumpBackIntegration {
    private static final String DEFAULT_URL = "https://humpback.ordermatecentral.com/HumpBack/webservices/";

    public static WebResource getHumpySyncWebResource(String endpoint) {
        WebResource resource = CloudIntegrationUtil.getPlainResource(HumpBackIntegration.getHumpBackWebserviceConfig(), endpoint);
        RestHelper rest = new RestHelper();
        resource = rest.addParameter(resource, "CCAgent", "AgentCyan");
        resource = rest.addParameter(resource, "redbackid", Long.toString(SystemCurrentInfo.getInstance().getRedbackId()));
        return resource;
    }

    public static WebserviceIntegrationConfig getHumpBackWebserviceConfig() {
        return HumpBackIntegration.getHumpBackConfig().getWebConfig();
    }

    public static CloudBackConfig getHumpBackConfig() {
        CloudBackConfig humpbackConfig = CloudBackConfig.getCloudBackConfig(CloudServerType.HumpBack);
        if (humpbackConfig == null) {
            humpbackConfig = new CloudBackConfig(CloudServerType.HumpBack);
            WebserviceIntegrationConfig webConfig = PersistenceManager.getObject(WebserviceIntegrationConfig.class, Query.select(WebserviceIntegrationConfig.class).equals(WebserviceIntegrationConfig.Properties.DESCRIPTION, CloudServerType.HumpBack.name()).toString());
            if (webConfig != null) {
                humpbackConfig.setWebConfig(webConfig);
            } else {
                webConfig = humpbackConfig.getWebConfig();
                webConfig.setUrl(DEFAULT_URL);
            }
            humpbackConfig.save();
        }
        return humpbackConfig;
    }
}

