/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.humpy;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.xmlintegration.humpback.mapping.HMMap;
import au.com.ordermate.xmlintegration.humpback.mapping.HMMapSet;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import ordermate.OrderMate;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.sales.unknown.SalesUnknown;
import ordermate.database.sales.unknown.SalesUnknownType;
import ordermate.integration.humpy.HumpBackIntegration;
import ordermate.integration.humpy.HumpBackSyncTask;

class HumpBackMappingSyncTask
implements HumpBackSyncTask {
    private boolean allGood = true;

    HumpBackMappingSyncTask() {
    }

    @Override
    public boolean needsSync() {
        ObjectQuery query = Query.count(SalesUnknown.class).not().isStringEmpty(SalesUnknown.Properties.SOURCE).not().isNull(SalesUnknown.Properties.POS_ID).equals((PropertiedObject.Property)SalesUnknown.Properties.SYNCED, Boolean.FALSE);
        Object[][] results = PersistenceManager.getPersistenceDelegate().executeQuery(query.toString(), new String[0]);
        int count = ((Number)results[0][0]).intValue();
        return count > 0;
    }

    @Override
    public boolean performSync() {
        this.allGood = true;
        List<String> providers = this.findUnsyncedProviders();
        for (String nextProvider : providers) {
            OrderMate.LOG.info("Synching for " + nextProvider);
            this.allGood = this.allGood && this.syncForProvider(nextProvider);
        }
        return this.allGood;
    }

    private List<String> findUnsyncedProviders() {
        ObjectQuery query = Query.select(SalesUnknown.Properties.SOURCE).not().isNull(SalesUnknown.Properties.POS_ID).equals((PropertiedObject.Property)SalesUnknown.Properties.SYNCED, Boolean.FALSE).groupBy(SalesUnknown.Properties.SOURCE);
        Object[][] result = PersistenceManager.getPersistenceDelegate().executeQuery(query.toString(), new Object[0]);
        ArrayList<String> providers = new ArrayList<String>();
        for (int i = 0; i < result.length; ++i) {
            providers.add(String.valueOf(result[i][0]));
        }
        return providers;
    }

    private void fillMasterIdFromThing(List<SalesUnknown> salesUnknownList) {
        ArrayList<SalesUnknown> withoutMasterIdList = new ArrayList<SalesUnknown>();
        for (SalesUnknown unknown : salesUnknownList) {
            Long masterId = this.getMasterIdIfPresent(unknown);
            if (masterId != null) {
                unknown.setMasterId(masterId);
                PersistenceManager.save(unknown);
                continue;
            }
            withoutMasterIdList.add(unknown);
        }
        salesUnknownList.removeAll(withoutMasterIdList);
    }

    private Long getMasterIdIfPresent(SalesUnknown unknown) {
        if (unknown.getMasterId() != null) {
            return unknown.getMasterId();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select masterId from ").append(unknown.getType().getTableName()).append(" where ID = ?");
        Object[][] masterIdArr = PersistenceManager.getPersistenceDelegate().executeQuery(sb.toString(), new Object[]{unknown.getPosId()});
        if (masterIdArr == null || masterIdArr.length == 0) {
            return null;
        }
        return (Long)masterIdArr[0][0];
    }

    private boolean syncForProvider(String provider) {
        HMMapSet mapSet = new HMMapSet();
        mapSet.setProvider(provider);
        mapSet.setStoreId(this.getStoreId());
        if (mapSet.getStoreId() == null) {
            OrderMate.LOG.warn("Cannot find the StoreId, will not attempt to sync");
            return false;
        }
        ObjectQuery query = Query.select(SalesUnknown.class).not().isNull(SalesUnknown.Properties.POS_ID).not().isStringEmpty(SalesUnknown.Properties.POS_ID).equals((PropertiedObject.Property)SalesUnknown.Properties.SYNCED, Boolean.FALSE).equals(SalesUnknown.Properties.SOURCE, provider).groupBy(SalesUnknown.Properties.EXT_ID).groupBy(SalesUnknown.Properties.TYPE);
        List<SalesUnknown> toSync = PersistenceManager.getObjectList(SalesUnknown.class, query.toString());
        if (toSync.isEmpty()) {
            OrderMate.LOG.info("No sales unknowns to be synchronised for :" + provider);
            return true;
        }
        this.fillMasterIdFromThing(toSync);
        if (toSync.isEmpty()) {
            OrderMate.LOG.info("No sales unknowns to be synchronised since there are no items with masterIds to be synced :" + provider);
            return true;
        }
        for (SalesUnknown nextUnknown : toSync) {
            HMMap map = this.createMap(nextUnknown);
            if (SalesUnknownType.Add.equals((Object)nextUnknown.getType())) {
                mapSet.getPlusses().add(map);
                continue;
            }
            if (SalesUnknownType.Combo.equals((Object)nextUnknown.getType())) {
                mapSet.getCombos().add(map);
                continue;
            }
            if (SalesUnknownType.Option.equals((Object)nextUnknown.getType())) {
                mapSet.getOptions().add(map);
                continue;
            }
            if (SalesUnknownType.Remove.equals((Object)nextUnknown.getType())) {
                mapSet.getMinuses().add(map);
                continue;
            }
            if (!SalesUnknownType.ItemUnit.equals((Object)nextUnknown.getType())) continue;
            mapSet.getUnits().add(map);
        }
        return this.sendMapSet(mapSet);
    }

    private Long getStoreId() {
        long value = SystemCurrentInfo.getInstance().getRedbackId();
        return value != 0L ? Long.valueOf(value) : null;
    }

    private HMMap createMap(SalesUnknown nextUnknown) {
        HMMap map = new HMMap();
        if (!StringUtils.isEmpty(nextUnknown.getExtId())) {
            map.setExtId(nextUnknown.getExtId().startsWith("-") ? nextUnknown.getExtId().substring(1) : nextUnknown.getExtId());
        }
        map.setPosId(nextUnknown.getMasterId());
        return map;
    }

    private boolean isResponseSuccessful(ClientResponse response) {
        return response != null && response.getStatus() / 100 == 2;
    }

    private boolean sendMapSet(HMMapSet set) {
        WebResource resource = HumpBackIntegration.getHumpySyncWebResource("posmapping");
        ClientResponse response = (ClientResponse)((WebResource.Builder)resource.type("application/xml").accept(new String[]{"application/xml"})).post(ClientResponse.class, (Object)set);
        if (response != null && this.isResponseSuccessful(response)) {
            HMMapSet responseSet = (HMMapSet)response.getEntity(HMMapSet.class);
            for (HMMap badCombo : responseSet.getCombos()) {
                this.removeFrom(SalesUnknownType.Combo, set.getCombos(), badCombo);
            }
            for (HMMap badUnit : responseSet.getUnits()) {
                this.removeFrom(SalesUnknownType.ItemUnit, set.getUnits(), badUnit);
            }
            for (HMMap badAdd : responseSet.getPlusses()) {
                this.removeFrom(SalesUnknownType.Add, set.getPlusses(), badAdd);
            }
            for (HMMap badRemove : responseSet.getMinuses()) {
                this.removeFrom(SalesUnknownType.Remove, set.getMinuses(), badRemove);
            }
            for (HMMap badOption : responseSet.getOptions()) {
                this.removeFrom(SalesUnknownType.Option, set.getOptions(), badOption);
            }
            this.markAllAsSynced(set);
            return true;
        }
        if (response != null && response.getStatus() == Response.Status.BAD_REQUEST.getStatusCode()) {
            OrderMate.LOG.error("Did not get a response from HumpBack Webservice on:" + (String)response.getEntity(String.class));
        }
        return false;
    }

    private void removeFrom(SalesUnknownType type, List<HMMap> things, HMMap badThing) {
        HMMap toRemove = null;
        for (HMMap map : things) {
            if (!map.getExtId().equals(badThing.getExtId())) continue;
            toRemove = map;
            break;
        }
        if (toRemove != null) {
            things.remove(toRemove);
            OrderMate.LOG.info("Cannot sync resolved unknown :" + (Object)((Object)type) + " pos_id=" + badThing.getPosId() + " ext_id=" + badThing.getExtId());
        }
    }

    private void markAllAsSynced(HMMapSet set) {
        String provider = set.getProvider();
        for (HMMap map : set.getCombos()) {
            this.markAsSynced(SalesUnknownType.Combo, provider, map);
        }
        for (HMMap map : set.getUnits()) {
            this.markAsSynced(SalesUnknownType.ItemUnit, provider, map);
        }
        for (HMMap map : set.getOptions()) {
            this.markAsSynced(SalesUnknownType.Option, provider, map);
        }
        for (HMMap map : set.getPlusses()) {
            this.markAsSynced(SalesUnknownType.Add, provider, map);
        }
        for (HMMap map : set.getMinuses()) {
            this.markAsSynced(SalesUnknownType.Remove, provider, map);
        }
    }

    private void markAsSynced(SalesUnknownType type, String provider, HMMap map) {
        String query = "UPDATE sales_unknown SET synced = true WHERE type = ? AND source = ? AND ext_id = ?";
        PersistenceManager.getPersistenceDelegate().executeUpdate(query, new Object[]{type.name(), provider, map.getExtId()});
    }

    @Override
    public String getResult() {
        return null;
    }
}

