/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.humpy;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.serialization.ShortReferenceStrategy;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.InventoryAddGroup;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.InventoryRemove;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.inventory.combos.InventoryComboGroupItemUnitLink;
import ordermate.database.inventory.combos.InventoryComboGroupSectionLink;
import ordermate.database.io.PersistentObjectIO;
import ordermate.database.io.PosMasterIdIO;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.OnlineIntegrationIDStrategy;
import ordermate.integration.humpy.HumpBackIntegration;
import ordermate.integration.humpy.HumpBackSyncTask;

public class HumpBackMenuSyncTask
implements HumpBackSyncTask {
    public static final List<? extends Class> inventoryClasses = Collections.unmodifiableList(Arrays.asList(InventoryCategory.class, InventoryItemPortion.class, InventoryItemSize.class, PriceLevel.class, InventoryOptionGroup.class, InventoryOption.class, InventoryAddGroup.class, InventoryAdd.class, InventoryProfile.class, InventoryGroup.class, InventoryItem.class, InventoryItemUnit.class, InventoryRemove.class, UnitPriceLevel.class, InventoryCombo.class, InventoryComboGroup.class, InventoryComboGroupItemUnitLink.class, InventoryComboGroupSectionLink.class));
    private static final String END_POINT = "sync/masterId";
    private String result = "No result";
    private StringBuilder SB;

    @Override
    public boolean needsSync() {
        if (SystemCurrentInfo.getInstance().getRedbackId() <= 0L) {
            OrderMate.LOG.warn("Cannot sync with Humpback! No RedBack ID is set! RedBackId: " + SystemCurrentInfo.getInstance().getRedbackId());
            return false;
        }
        if (!OnlineIntegrationIDStrategy.MASTER_ID.equals((Object)SystemProperty.getInstance().getOnlineIntegrationIdStrategy())) {
            OrderMate.LOG.warn("Cannot sync with Humpback! Online Integration ID Strategy is NOT set as MASTER_ID!");
            return false;
        }
        return true;
    }

    @Override
    public boolean performSync() {
        this.SB = new StringBuilder();
        for (Class clazz : inventoryClasses) {
            this.doSyncForClass(clazz);
        }
        OrderMate.LOG.info("Result of Sync:\r\n" + this.SB.toString());
        return true;
    }

    private void doSyncForClass(Class nextClass) {
        ObjectQuery query = Query.select(nextClass).whereFunction("masterId IS NULL");
        if (PropertiedObject.PropsHelper.getProperties(nextClass).hasProperty("systemState")) {
            query.active(nextClass);
        }
        List<PersistentObjectI> objs = PersistenceManager.getObjectList(nextClass, query.toString());
        OrderMate.LOG.info("Doing humpback sync for " + objs.size() + " " + nextClass.getSimpleName());
        long tally = 0L;
        for (PersistentObjectI obj : objs) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            PersistentObjectIO<PersistentObjectI> io = new PersistentObjectIO<PersistentObjectI>(false);
            io.setReferenceStrategy(new ShortReferenceStrategy(io));
            String output = null;
            try {
                io.writeOut(obj, bout);
                bout.flush();
                bout.close();
                output = new String(bout.toByteArray());
                tally += (long)output.length();
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot convert object " + obj, (Throwable)ex);
            }
            if (output == null || output.isEmpty()) continue;
            this.sendToHumpy(output);
        }
        if (objs.size() > 0) {
            OrderMate.LOG.info("Average size:" + tally / (long)objs.size());
        }
    }

    private void sendToHumpy(String xml) {
        WebResource resource = HumpBackIntegration.getHumpySyncWebResource(END_POINT);
        ClientResponse response = (ClientResponse)((WebResource.Builder)resource.accept(new String[]{"application/xml"}).type("application/xml")).post(ClientResponse.class, (Object)xml);
        if (response != null && response.getStatus() / 100 == 2) {
            String entity = (String)response.getEntity(String.class);
            this.processResponse(entity);
        } else if (response == null) {
            OrderMate.LOG.warn("Error while synching with Humpback " + xml + "\r\nNo Response");
            this.SB.append("Error, no response");
        } else {
            String entity = (String)response.getEntity(String.class);
            OrderMate.LOG.warn("Error while synching with Humpback " + xml + "\r\n" + entity);
            this.SB.append("Error " + entity);
        }
    }

    private void processResponse(String response) {
        OrderMate.LOG.info("Response:" + response);
        List list = null;
        try {
            list = (List)new PosMasterIdIO().readIn(new ByteArrayInputStream(response.getBytes()));
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Fail to resolve humpy response", (Throwable)ex);
            this.SB.append("Fail to resolve humpback response.\r\n");
        }
        if (list != null) {
            for (PersistentObject obj : list) {
                if (obj instanceof Saveable) {
                    ((Saveable)((Object)obj)).save();
                    continue;
                }
                if (!(obj instanceof SaveableChild)) continue;
                ((SaveableChild)((Object)obj)).saveChild();
            }
        }
    }

    @Override
    public String getResult() {
        return this.result;
    }
}

