/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.humpy;

import java.util.concurrent.Semaphore;
import ordermate.OrderMate;
import ordermate.integration.humpy.HumpBackMappingSyncTask;
import ordermate.integration.humpy.HumpBackMenuSyncTask;

public class HumpBackSync {
    private final Semaphore semaphore = new Semaphore(1);
    private static HumpBackSync instance = new HumpBackSync();
    private final HumpBackMenuSyncTask menuSync = new HumpBackMenuSyncTask();
    private final HumpBackMappingSyncTask mappingSync = new HumpBackMappingSyncTask();

    public static HumpBackSync getInstance() {
        return instance;
    }

    private HumpBackSync() {
    }

    public boolean needsSync() {
        return this.menuSync.needsSync() || this.mappingSync.needsSync();
    }

    public boolean performSync() {
        if (!this.needsSync()) {
            OrderMate.LOG.warn("No Sync Required for HumpBack!");
            return false;
        }
        if (!this.semaphore.tryAcquire()) {
            return false;
        }
        boolean allGood = true;
        try {
            allGood = this.menuSync.performSync();
            allGood &= this.mappingSync.performSync();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Problem synchronising to humpback", (Throwable)ex);
        }
        finally {
            this.semaphore.release();
        }
        return allGood;
    }
}

