/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.invoicing;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockItemSupplier;
import ordermate.database.stock.StockSupplier;

public abstract class ExternalInvoiceResolver {
    private ObjectQuery extIdQuery;

    public ExternalInvoiceResolver() {
        this.extIdQuery = Query.select(StockItem.class).equalsParam(StockItem.Properties.EXT_ID).active(StockItem.class);
    }

    public StockItem findStockForExternalId(StockItem prototype) {
        List<StockItem> items = PersistenceManager.getObjectList(StockItem.class, this.extIdQuery.toString(), new Object[]{prototype.getExtId()});
        StockItem item = null;
        if (items.isEmpty()) {
            item = this.getItemFromStockItemSupp(prototype);
            if (item == null) {
                item = this.doMatchItem(prototype);
            }
            if (item != null) {
                item.setExtId(prototype.getExtId());
                item.save();
            }
        } else {
            item = items.size() > 1 ? this.doDuplicateItems(prototype, items) : items.get(0);
        }
        return item;
    }

    public StockItem findStockItemForSupplierCode(StockItem prototype, StockSupplier supplier, String supplierCode) {
        List<StockItemSupplier> links = PersistenceManager.getObjectList(StockItemSupplier.class, Query.select(StockItemSupplier.class).equals(StockItemSupplier.Properties.STOCK_SUPPLIER, supplier).equals(StockItemSupplier.Properties.PRODUCT_CODE, supplierCode).linkUsing(StockItemSupplier.Properties.STOCK_ITEM).active(StockItem.class).toString(), null);
        StockItem matchedItem = null;
        if (links.size() == 1) {
            matchedItem = links.get(0).getStockItem();
        } else if (links.size() > 1) {
            ArrayList<StockItem> items = new ArrayList<StockItem>();
            for (StockItemSupplier stockItemSupplier : links) {
                items.add(stockItemSupplier.getStockItem());
            }
            matchedItem = this.doDuplicateItems(prototype, items);
        } else if (links.size() == 0 && (matchedItem = this.doMatchItem(prototype)) != null) {
            matchedItem.addSupplier(supplier, supplierCode);
            matchedItem.save();
        }
        return matchedItem;
    }

    private StockItem getItemFromStockItemSupp(StockItem prototype) {
        ObjectQuery stkItemSuppQuery = Query.select(StockItemSupplier.class).equalsParam(StockItemSupplier.Properties.PRODUCT_CODE).distinct().not().isNull(StockItemSupplier.Properties.STOCK_ITEM);
        List<StockItemSupplier> stkItemSuppList = PersistenceManager.getObjectList(StockItemSupplier.class, stkItemSuppQuery.toString(), new Object[]{prototype.getExtId()});
        if (!stkItemSuppList.isEmpty() && stkItemSuppList.size() == 1 && stkItemSuppList.get(0).getStockItem().getExtId() == null) {
            return stkItemSuppList.get(0).getStockItem();
        }
        return null;
    }

    public StockSupplier resolveSupplier(StockSupplier prototype) {
        StockSupplier supplier = StockSupplier.getSupplierForName(prototype.getLabel());
        if (supplier == null) {
            supplier = this.doMissingSupplier(prototype);
        }
        return supplier;
    }

    protected abstract StockSupplier doMissingSupplier(StockSupplier var1);

    protected abstract StockItem doDuplicateItems(StockItem var1, List<StockItem> var2);

    protected abstract StockItem doMatchItem(StockItem var1);
}

