/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.invoicing.alm;

import ordermate.integration.invoicing.alm.ALMFileHeader;
import ordermate.integration.invoicing.alm.ALMFileType;
import ordermate.integration.invoicing.alm.ALMUtils;
import ordermate.integration.invoicing.alm.AbstractALMLineReader;

class ALMFileHeaderReader
extends AbstractALMLineReader<ALMFileHeader> {
    private static final String RECORD_TYPE = "FH";
    private static final int RT = 2;
    private static final int FILE_TYPE = 20;
    private static final int RECORD_SIZE = 5;
    private static final int BLOCK_FACTOR = 5;
    private static final int TAIL_FILLER = 20;
    private static final int LENGTH = 32;

    ALMFileHeaderReader() {
    }

    @Override
    public ALMFileHeader readObject(String line) {
        int index = 2;
        String fileType = line.substring(index, index += 20).trim();
        String recordSize = line.substring(index, index += 5).trim();
        String blockFactor = line.substring(index, index += 5).trim();
        return new ALMFileHeader(ALMFileType.valueOf(fileType.trim()), ALMUtils.getInteger(recordSize), ALMUtils.getInteger(blockFactor));
    }

    @Override
    protected String getRequiredPrefix() {
        return RECORD_TYPE;
    }

    @Override
    protected int getRequiredLength() {
        return 32;
    }
}

