/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.invoicing.alm;

import java.util.Date;
import ordermate.integration.invoicing.alm.ALMHeader;
import ordermate.integration.invoicing.alm.ALMUtils;
import ordermate.integration.invoicing.alm.AbstractALMLineReader;

class ALMHeaderReader
extends AbstractALMLineReader<ALMHeader> {
    private static final String HEADER_MARKER = "TH";
    private static final int RECORD_TYPE = 2;
    private static final int TRANS_TYPE = 20;
    private static final int SOURCE_STATE = 3;
    private static final int DESTINATION = 20;
    private static final int DATE = 8;
    private static final int TIME = 5;
    private static final int TAIL_FILLER = 22;
    public static final int LINE_LENGTH = 58;

    ALMHeaderReader() {
    }

    @Override
    public ALMHeader readObject(String line) {
        int index = 2;
        String trans = line.substring(index, index += 20).trim();
        String state = line.substring(index, index += 3).trim();
        String dest = line.substring(index, index += 20).trim();
        String datePart = line.substring(index, index += 8).trim();
        String timePart = line.substring(index, index += 5).trim();
        Date datetime = ALMUtils.makeDateFromALMString(datePart, timePart);
        return new ALMHeader(trans, state, dest, datetime);
    }

    @Override
    protected String getRequiredPrefix() {
        return HEADER_MARKER;
    }

    @Override
    protected int getRequiredLength() {
        return 58;
    }
}

