/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.invoicing.alm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum ALMProductStatus {
    Avail("0", "Available"),
    TOS("1", "Temporarily Out Of Stock"),
    TNA("2", "Temporarily Not Available"),
    NIR("3", "Not In Range"),
    NEW("4", "New Line"),
    DEL("5", "Deleted Line"),
    DIR("6", "Direct Item");

    public static Map<String, ALMProductStatus> indexMap;
    private final String index;
    private final String label;

    private ALMProductStatus(String index, String value) {
        this.index = index;
        this.label = value;
    }

    public String getLabel() {
        return this.label;
    }

    public String getIndex() {
        return this.index;
    }

    public static final Map<String, ALMProductStatus> getIndexMap() {
        return Collections.unmodifiableMap(indexMap);
    }

    static {
        indexMap = new HashMap<String, ALMProductStatus>();
        for (ALMProductStatus status : ALMProductStatus.values()) {
            indexMap.put(status.index, status);
        }
    }
}

