/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.invoicing.alm;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.integration.invoicing.alm.ALMFileHeader;
import ordermate.integration.invoicing.alm.ALMFileHeaderReader;
import ordermate.integration.invoicing.alm.ALMFileType;
import ordermate.integration.invoicing.alm.ALMHeader;
import ordermate.integration.invoicing.alm.ALMHeaderReader;
import ordermate.integration.invoicing.alm.invoice.ALMInvoice;
import ordermate.integration.invoicing.alm.invoice.ALMInvoiceReader;

public class ALMReader {
    private static final int MINIMUM_LENGTH = 4;
    private GuiHandler gui;
    private List<ALMInvoice> invoices;

    public ALMReader(GuiHandler yourHandler) {
        this.gui = yourHandler;
    }

    public boolean handleFile(File file) {
        List<String> data = null;
        try {
            FileInputStream fin = new FileInputStream(file);
            data = StringUtils.readLinesFromStream(fin, true);
        }
        catch (IOException ex) {
            this.handleCannotReadFile(file, ex);
            return false;
        }
        if (data.size() < 4) {
            OrderMate.LOG.warn("Cannot process this file, there must be at least 4 rows to process.");
            return false;
        }
        return this.processDataFromALMFile(data);
    }

    private void handleCannotReadFile(File file, IOException ex) {
        OrderMate.LOG.warn("Couldn't process ALM File:", (Throwable)ex);
        this.gui.displayOkDialog("ALM File is invalid", ex.toString());
    }

    private boolean processDataFromALMFile(List<String> fileData) {
        ALMHeaderReader headerReader = new ALMHeaderReader();
        ALMHeader header = headerReader.readObject(fileData.get(0));
        if (header != null && header.isValid()) {
            OrderMate.LOG.info("ALM Header is valid, processing...");
            this.processData(fileData);
            return true;
        }
        OrderMate.LOG.info("The ALM file was readable, but is not an invoice file.");
        return false;
    }

    private void processData(List<String> data) {
        ALMFileHeaderReader fileHeaderReader = new ALMFileHeaderReader();
        if (fileHeaderReader.canHandle(data.get(1))) {
            ALMFileHeader header = fileHeaderReader.readObject(data.get(1));
            if (header != null) {
                if (ALMFileType.INVOICING.equals((Object)header.getFileType())) {
                    OrderMate.LOG.info("This is an ALM Invoice, processing...");
                    this.processInvoice(data.subList(2, data.size() - 1));
                } else {
                    OrderMate.LOG.warn("Unknown ALM file type, cannot process:" + (Object)((Object)header.getFileType()));
                }
            } else {
                OrderMate.LOG.warn("Cannot Process File, file header has issues.");
            }
        } else {
            OrderMate.LOG.warn("Cannot process ALM File, invalid File Reader type");
        }
    }

    private void processInvoice(List<String> dataList) {
        ALMInvoiceReader reader = new ALMInvoiceReader();
        try {
            reader.processInvoice(dataList);
            this.invoices = new ArrayList<ALMInvoice>(reader.getInvoices());
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Could not process data as an ALM invoice:", (Throwable)ex);
        }
    }

    public List<ALMInvoice> getInvoices() {
        return this.invoices;
    }
}

