/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.invoicing.alm;

import au.com.ordermate.util.Price;
import java.util.Calendar;
import java.util.Date;
import ordermate.OrderMate;

public class ALMUtils {
    public static Date makeDateFromALMString(String datePart, String timePart) {
        if (datePart.length() == 6) {
            return ALMUtils.doSixDigitPart(datePart);
        }
        Calendar cal = Calendar.getInstance();
        cal.set(1, Integer.parseInt(datePart.substring(4, 8)));
        cal.set(2, Integer.parseInt(datePart.substring(2, 4)) - 1);
        cal.set(5, Integer.parseInt(datePart.substring(0, 2)));
        cal.set(11, Integer.parseInt(timePart.substring(0, 2)));
        cal.set(12, Integer.parseInt(timePart.substring(3, 5)));
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private static Date doSixDigitPart(String datePart) {
        if (datePart.equals("000000")) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2000 + Integer.parseInt(datePart.substring(4, 6)));
        cal.set(2, Integer.parseInt(datePart.substring(2, 4)) - 1);
        cal.set(5, Integer.parseInt(datePart.substring(0, 2)));
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date makeDateFromALMString(String date) {
        return ALMUtils.makeDateFromALMString(date, "00:00");
    }

    public static int getInteger(String toParse) {
        if (toParse == null) {
            return 0;
        }
        String trimmed = toParse.trim();
        if (trimmed.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(trimmed);
        }
        catch (NumberFormatException ex) {
            OrderMate.LOG.warn("Cannot parse integer, bad format:", (Throwable)ex);
            return 0;
        }
    }

    public static long getLong(String toParse) {
        if (toParse == null) {
            return 0L;
        }
        String trimmed = toParse.trim();
        if (trimmed.isEmpty()) {
            return 0L;
        }
        try {
            return Long.parseLong(trimmed);
        }
        catch (NumberFormatException ex) {
            OrderMate.LOG.warn("Cannot parse long, bad format:", (Throwable)ex);
            return 0L;
        }
    }

    public static double getDouble(String toParse, int precision) {
        if (toParse == null || toParse.trim().isEmpty()) {
            return 0.0;
        }
        StringBuilder SB = new StringBuilder(toParse.substring(0, toParse.length() - precision));
        SB.append(".").append(toParse.substring(toParse.length() - precision));
        try {
            return Double.parseDouble(SB.toString());
        }
        catch (NumberFormatException ex) {
            OrderMate.LOG.warn("Cannot parse Double from ALM String, bad format:", (Throwable)ex);
            return 0.0;
        }
    }

    public static double getSignedDouble(String toParse, int precision) {
        if (toParse == null || toParse.trim().isEmpty()) {
            return 0.0;
        }
        double value = ALMUtils.getDouble(toParse.substring(0, toParse.length() - 1), precision);
        if (toParse.charAt(toParse.length() - 1) == '-') {
            value = -value;
        }
        return value;
    }

    public static Price getPrice(String toParse) {
        if (toParse == null || toParse.trim().isEmpty()) {
            return Price.ZERO_DOLLAR;
        }
        try {
            StringBuilder SB = new StringBuilder(toParse.substring(0, toParse.length() - 2));
            SB.append(".").append(toParse.substring(toParse.length() - 1, toParse.length()));
            return Price.parsePrice(SB.toString());
        }
        catch (NumberFormatException ex) {
            OrderMate.LOG.warn("Cannot parse price from ALM String, bad format:", (Throwable)ex);
            return Price.ZERO_DOLLAR;
        }
    }

    public static Price getSignedPrice(String toParse) {
        if (toParse == null || toParse.trim().isEmpty()) {
            return Price.ZERO_DOLLAR;
        }
        Price price = ALMUtils.getPrice(toParse.substring(0, toParse.length() - 1));
        if (toParse.charAt(toParse.length() - 1) == '-') {
            price = price.negate();
        }
        return price;
    }
}

