/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.invoicing.alm.invoice;

import java.util.ArrayList;
import java.util.List;
import ordermate.integration.invoicing.alm.invoice.ALMInvoiceEntry;
import ordermate.integration.invoicing.alm.invoice.ALMInvoiceFooter;
import ordermate.integration.invoicing.alm.invoice.ALMInvoiceHeader;

public class ALMInvoice {
    private ALMInvoiceHeader invoiceHeader;
    private ALMInvoiceFooter invoiceFooter;
    private List<ALMInvoiceEntry> invoiceEntries = new ArrayList<ALMInvoiceEntry>();

    ALMInvoice(ALMInvoiceHeader yourHeader) {
        this.invoiceHeader = yourHeader;
    }

    void addInvoiceEntry(ALMInvoiceEntry invoiceRow) {
        if (this.invoiceFooter != null) {
            throw new IllegalStateException("Cannot add invoice entries to an invoice after it has been finalised");
        }
        this.invoiceEntries.add(invoiceRow);
    }

    void finaliseInvoice(ALMInvoiceFooter footer) {
        this.invoiceFooter = footer;
    }

    public boolean isComplete() {
        return this.invoiceHeader != null && this.invoiceFooter != null && !this.invoiceEntries.isEmpty();
    }

    public final ALMInvoiceHeader getInvoiceHeader() {
        return this.invoiceHeader;
    }

    public final ALMInvoiceFooter getInvoiceFooter() {
        return this.invoiceFooter;
    }

    public final List<ALMInvoiceEntry> getInvoiceEntries() {
        return this.invoiceEntries;
    }
}

