/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.invoicing.alm.invoice;

import java.util.Map;
import ordermate.OrderMate;
import ordermate.integration.invoicing.alm.ALMProductStatus;
import ordermate.integration.invoicing.alm.ALMUtils;
import ordermate.integration.invoicing.alm.AbstractALMLineReader;
import ordermate.integration.invoicing.alm.invoice.ALMInvoiceEntry;
import ordermate.integration.invoicing.alm.invoice.ALMItemType;
import ordermate.integration.invoicing.alm.invoice.ALMOrderType;

class ALMInvoiceEntryReader
extends AbstractALMLineReader<ALMInvoiceEntry> {
    private static final String PRE = "FD";
    private static final int PREFIX = 2;
    private static final int INVOICE_NUM = 5;
    private static final int CLAIM_NUM = 6;
    private static final int PAGE_NUM = 3;
    private static final int LINE_NUM = 2;
    private static final int CUSTOMER_CODE = 6;
    private static final int PRODUCT_STATUS = 1;
    private static final int AVAILABLE_DATE = 6;
    private static final int COMMODITY_GROUP = 5;
    private static final int SUPPLIER_NUM = 5;
    private static final int PRODUCT_DESC = 30;
    private static final int ITEM_TYPE = 1;
    private static final int ORDER_TYPE = 1;
    private static final int ITEM_NUM = 6;
    private static final int ORIGINAL_ITEM = 6;
    private static final int WHOLESALE_PACK_QTY = 4;
    private static final int RETAIL_PACK_QTY = 4;
    private static final int UNITS_ORDERED = 7;
    private static final int UNITS_SUPPLIED = 7;
    private static final int UNITS_SUPPLIED_SIGN = 1;
    private static final int WET_RATE = 5;
    private static final int GST_RATE = 5;
    private static final int CONTAINER_DEPOSIT = 5;
    private static final int BASE_PRICE = 7;
    private static final int WET_VALUE = 7;
    private static final int GST_VALUE = 7;
    private static final int DELIVERY_FEE = 5;
    private static final int CASE_PRICE = 7;
    private static final int ADMIN_FEE_PER_CASE = 6;
    private static final int ADMIN_FEE_QUALIFIER = 1;
    private static final int EXTEND_WHOLESALE = 10;
    private static final int FINANCE_FEE_PER_CASE = 6;
    private static final int EXTEND_WET_VALUE = 10;
    private static final int EXTEND_GST_VALUE = 10;
    private static final int LANDED_UNIT_COST_EX = 6;
    private static final int RECOMMENDED_RETAIL = 7;
    private static final int TOTAL_LITRES = 10;
    private static final int APN_CODE = 13;
    private static final int TUN_CODE = 14;
    private static final int FILLER = 1;
    private Map<String, ALMProductStatus> statusMap = ALMProductStatus.getIndexMap();
    private Map<String, ALMOrderType> orderMap = ALMOrderType.getIndexMap();
    private Map<String, ALMItemType> itemMap = ALMItemType.getIndexMap();

    ALMInvoiceEntryReader() {
    }

    @Override
    public ALMInvoiceEntry readObject(String data) {
        OrderMate.LOG.info("Reading in invoice entry from data.");
        ALMInvoiceEntry detail = new ALMInvoiceEntry();
        int index = 2;
        detail.setInvoiceNum(ALMUtils.getInteger(data.substring(index, index += 5)));
        detail.setClaimNum(ALMUtils.getInteger(data.substring(index, index += 6)));
        detail.setPageNum(ALMUtils.getInteger(data.substring(index, index += 3)));
        detail.setLineNum(ALMUtils.getInteger(data.substring(index, index += 2)));
        detail.setCustomerCode(ALMUtils.getInteger(data.substring(index, index += 6)));
        detail.setProductStatus(this.statusMap.get(data.substring(index++, index)));
        detail.setAvailDate(ALMUtils.makeDateFromALMString(data.substring(index, index += 6)));
        detail.setCommodityGroup(ALMUtils.getInteger(data.substring(index, index += 5)));
        detail.setSupplierNumber(ALMUtils.getInteger(data.substring(index, index += 5)));
        detail.setProductDesc(data.substring(index, index += 30).trim());
        detail.setItemType(this.itemMap.get(data.substring(index++, index)));
        detail.setOrderType(this.orderMap.get(data.substring(index++, index)));
        detail.setItemNumber(ALMUtils.getInteger(data.substring(index, index += 6)));
        detail.setOriginalItem(ALMUtils.getInteger(data.substring(index, index += 6)));
        detail.setWholesalePackQty(ALMUtils.getInteger(data.substring(index, index += 4)));
        detail.setRetailPackQty(ALMUtils.getInteger(data.substring(index, index += 4)));
        detail.setUnitsOrdered(ALMUtils.getInteger(data.substring(index, index += 7)));
        detail.setUnitsSupplied(ALMUtils.getInteger(data.substring(index, index += 7)));
        detail.setUnitsSuppliedSign(data.substring(index++, index));
        detail.setWetRate(ALMUtils.getDouble(data.substring(index, index += 5), 2));
        detail.setGSTRate(ALMUtils.getDouble(data.substring(index, index += 5), 2));
        detail.setContainerDeposit(ALMUtils.getPrice(data.substring(index, index += 5)));
        detail.setBasePrice(ALMUtils.getPrice(data.substring(index, index += 7)));
        detail.setWetValue(ALMUtils.getPrice(data.substring(index, index += 7)));
        detail.setGstValue(ALMUtils.getPrice(data.substring(index, index += 7)));
        detail.setDeliveryFee(ALMUtils.getPrice(data.substring(index, index += 5)));
        detail.setCasePrice(ALMUtils.getPrice(data.substring(index, index += 7)));
        detail.setAdminFeePerCase(ALMUtils.getPrice(data.substring(index, index += 6)));
        detail.setAdminFeeQualifier(data.substring(index++, index));
        detail.setExtendedWholesale(ALMUtils.getSignedPrice(data.substring(index, index += 10)));
        detail.setFinanceFeePerCase(ALMUtils.getPrice(data.substring(index, index += 6)));
        detail.setExtendedWetValue(ALMUtils.getSignedPrice(data.substring(index, index += 10)));
        detail.setExtendedGstValue(ALMUtils.getSignedPrice(data.substring(index, index += 10)));
        detail.setLandedUnitCostExGst(ALMUtils.getPrice(data.substring(index, index += 6)));
        detail.setRecommendedRetail(ALMUtils.getPrice(data.substring(index, index += 7)));
        detail.setTotalLitres(ALMUtils.getSignedDouble(data.substring(index, index += 10), 1));
        detail.setAPNCode(ALMUtils.getLong(data.substring(index, index += 13)));
        detail.setTUNCode(ALMUtils.getLong(data.substring(index, index += 14)));
        return detail;
    }

    @Override
    protected String getRequiredPrefix() {
        return PRE;
    }

    @Override
    protected int getRequiredLength() {
        return 249;
    }
}

