/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.invoicing.alm.invoice;

import ordermate.OrderMate;
import ordermate.integration.invoicing.alm.ALMUtils;
import ordermate.integration.invoicing.alm.AbstractALMLineReader;
import ordermate.integration.invoicing.alm.invoice.ALMInvoiceFooter;

public class ALMInvoiceFooterReader
extends AbstractALMLineReader<ALMInvoiceFooter> {
    private static final String PREFIX = "FD";
    private static final int INVOICE_NUM = 5;
    private static final int CLAIM_NUM = 6;
    private static final int PAGE_NUM = 3;
    private static final int LINE_NUM = 2;
    private static final int CUSTOMER_CODE = 6;
    private static final int DELIVERY_FEE = 10;
    private static final int INVOICE_SUB_TOTAL = 10;
    private static final int ADMIN_FEE = 10;
    private static final int SHRINK_WRAP = 9;
    private static final int INVOICE_TOTAL = 10;
    private static final int TOTAL_WEIGHT = 10;
    private static final int TOTAL_WET = 10;
    private static final int TOTAL_GST = 10;
    private static final int GST_APPLIC = 10;
    private static final int FINANCE_FEE = 10;
    private static final int WINE_LITRES = 10;
    private static final int WINE_VALUE = 10;
    private static final int SPIRIT_LITRES = 10;
    private static final int SPIRIT_VALUE = 10;
    private static final int BEER_LITRES = 10;
    private static final int BEER_VALUE = 10;
    private static final int MID_BEER_LITRES = 10;
    private static final int MID_BEER_VALUE = 10;
    private static final int LOW_BEER_LITRES = 10;
    private static final int LOW_BEER_VALUE = 10;
    private static final int LOW_WINE_LITRES = 10;
    private static final int LOW_WINE_VALUE = 10;
    private static final int FILLER = 56;
    private static final int DISCRIMINATOR = "FD".length() + 6 + 5;
    private static final int LENGTH = 241;

    @Override
    public ALMInvoiceFooter readObject(String data) {
        OrderMate.LOG.info("Reading in invoice footer from data.");
        ALMInvoiceFooter footer = new ALMInvoiceFooter();
        int index = PREFIX.length();
        footer.setInvoiceNumber(ALMUtils.getInteger(data.substring(index, index += 5)));
        footer.setClaimNumber(ALMUtils.getInteger(data.substring(index, index += 6)));
        footer.setPageNumber(ALMUtils.getInteger(data.substring(index, index += 3)));
        footer.setLineNumber(ALMUtils.getInteger(data.substring(index, index += 2)));
        footer.setCustomerCode(ALMUtils.getInteger(data.substring(index, index += 6)));
        footer.setDeliveryFee(ALMUtils.getSignedPrice(data.substring(index, index += 10)));
        footer.setInvoiceSubTotal(ALMUtils.getSignedPrice(data.substring(index, index += 10)));
        footer.setAdminFee(ALMUtils.getSignedPrice(data.substring(index, index += 10)));
        footer.setShrinkWrap(ALMUtils.getPrice(data.substring(index, index += 9)));
        footer.setInvoiceTotal(ALMUtils.getSignedPrice(data.substring(index, index += 10)));
        footer.setTotalWeight(ALMUtils.getSignedDouble(data.substring(index, index += 10), 1));
        footer.setTotalWet(ALMUtils.getSignedPrice(data.substring(index, index += 10)));
        footer.setTotalGst(ALMUtils.getSignedPrice(data.substring(index, index += 10)));
        footer.setGstApplic(ALMUtils.getSignedPrice(data.substring(index, index += 10)));
        footer.setFinanceFee(ALMUtils.getSignedPrice(data.substring(index, index += 10)));
        footer.setWineLitres(ALMUtils.getSignedDouble(data.substring(index, index += 10), 1));
        footer.setWineValue(ALMUtils.getSignedPrice(data.substring(index, index += 10)));
        footer.setSpiritLitres(ALMUtils.getSignedDouble(data.substring(index, index += 10), 1));
        footer.setSpiritValue(ALMUtils.getSignedPrice(data.substring(index, index += 10)));
        footer.setBeerLitres(ALMUtils.getSignedDouble(data.substring(index, index += 10), 1));
        footer.setBeerValue(ALMUtils.getSignedPrice(data.substring(index, index += 10)));
        footer.setMidLitres(ALMUtils.getSignedDouble(data.substring(index, index += 10), 1));
        footer.setMidValue(ALMUtils.getSignedPrice(data.substring(index, index += 10)));
        footer.setLowBeerLitres(ALMUtils.getSignedDouble(data.substring(index, index += 10), 1));
        footer.setLowBeerValue(ALMUtils.getSignedPrice(data.substring(index, index += 10)));
        footer.setLowWineLitres(ALMUtils.getSignedDouble(data.substring(index, index += 10), 1));
        footer.setLowWineValue(ALMUtils.getSignedPrice(data.substring(index, index += 10)));
        return footer;
    }

    @Override
    protected String getRequiredPrefix() {
        return PREFIX;
    }

    @Override
    protected int getRequiredLength() {
        return 241;
    }

    @Override
    public boolean canHandle(String data) {
        return super.canHandle(data) && data.substring(DISCRIMINATOR, DISCRIMINATOR + 3 + 2).equals("99999");
    }
}

