/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.invoicing.alm.invoice;

import ordermate.OrderMate;
import ordermate.integration.invoicing.alm.ALMUtils;
import ordermate.integration.invoicing.alm.AbstractALMLineReader;
import ordermate.integration.invoicing.alm.invoice.ALMInvoiceHeader;

class ALMInvoiceHeaderReader
extends AbstractALMLineReader<ALMInvoiceHeader> {
    private static final String PRE = "FD";
    private static final int PREFIX = 2;
    private static final int INVOICE_NUMBER = 5;
    private static final int CLAIM_NUMBER = 6;
    private static final int PAGE_NUMBER = 3;
    private static final int LINE_NUMBER = 2;
    private static final int CUSTOMER_CODE = 6;
    private static final int ORDER_NUMBER = 10;
    private static final int STORE_NAME = 30;
    private static final int STREET = 25;
    private static final int SUBURB = 20;
    private static final int POST_CODE = 4;
    private static final int DEBTOR_CODE = 7;
    private static final int LICENSE_NUMBER = 8;
    private static final int BOND_NUMBER = 6;
    private static final int MESSAGE = 20;
    private static final int INVOICE_DATE = 8;
    private static final int ABN = 14;
    private static final int TAIL_FILLER = 24;
    private static final int DISCRIMINATOR = 13;
    private static final int LENGTH = 176;

    ALMInvoiceHeaderReader() {
    }

    @Override
    public ALMInvoiceHeader readObject(String data) {
        OrderMate.LOG.info("Reading in invoice header from data.");
        ALMInvoiceHeader header = new ALMInvoiceHeader();
        int index = 2;
        header.setInvoiceNum(Integer.parseInt(data.substring(index, index += 5)));
        header.setClaimNum(ALMUtils.getInteger(data.substring(index, index += 6)));
        header.setPageNum(ALMUtils.getInteger(data.substring(index, index += 3)));
        header.setLineNum(ALMUtils.getInteger(data.substring(index, index += 2)));
        header.setCustomerCode(ALMUtils.getInteger(data.substring(index, index += 6)));
        header.setOrderNum(data.substring(index, index += 10).trim());
        header.setStoreName(data.substring(index, index += 30).trim());
        header.setStreet(data.substring(index, index += 25).trim());
        header.setSuburb(data.substring(index, index += 20).trim());
        header.setPostcode(ALMUtils.getInteger(data.substring(index, index += 4)));
        header.setDebtorCode(ALMUtils.getInteger(data.substring(index, index += 7)));
        header.setLicenseNumber(data.substring(index, index += 8).trim());
        header.setBondNumber(data.substring(index, index += 6).trim());
        header.setMessage(data.substring(index, index += 20).trim());
        header.setInvoiceDate(ALMUtils.makeDateFromALMString(data.substring(index, index += 8)));
        header.setABN(data.substring(index, index += 14).trim());
        return header;
    }

    @Override
    protected String getRequiredPrefix() {
        return PRE;
    }

    @Override
    public boolean canHandle(String line) {
        return super.canHandle(line) && line.substring(13, 18).equals("00000");
    }

    @Override
    protected int getRequiredLength() {
        return 176;
    }
}

