/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.invoicing.alm.invoice;

import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.integration.invoicing.alm.invoice.ALMInvoice;
import ordermate.integration.invoicing.alm.invoice.ALMInvoiceEntry;
import ordermate.integration.invoicing.alm.invoice.ALMInvoiceEntryReader;
import ordermate.integration.invoicing.alm.invoice.ALMInvoiceFooter;
import ordermate.integration.invoicing.alm.invoice.ALMInvoiceFooterReader;
import ordermate.integration.invoicing.alm.invoice.ALMInvoiceHeader;
import ordermate.integration.invoicing.alm.invoice.ALMInvoiceHeaderReader;

public class ALMInvoiceReader {
    private List<ALMInvoice> receivedInvoices = new ArrayList<ALMInvoice>();
    private List<String> errors;

    public void processInvoice(List<String> data) {
        ALMInvoiceHeaderReader headerReader = new ALMInvoiceHeaderReader();
        ALMInvoiceEntryReader entryReader = new ALMInvoiceEntryReader();
        ALMInvoiceFooterReader footerReader = new ALMInvoiceFooterReader();
        ALMInvoice invoice = null;
        for (String nextLine : data) {
            if (headerReader.canHandle(nextLine)) {
                invoice = this.startNewInvoice(headerReader.readObject(nextLine));
                continue;
            }
            if (footerReader.canHandle(nextLine)) {
                this.finishInvoice(invoice, footerReader.readObject(nextLine));
                invoice = null;
                continue;
            }
            if (!entryReader.canHandle(nextLine)) continue;
            this.addToInvoice(invoice, entryReader.readObject(nextLine));
        }
    }

    private ALMInvoice startNewInvoice(ALMInvoiceHeader header) {
        ALMInvoice invoice = new ALMInvoice(header);
        return invoice;
    }

    private void addToInvoice(ALMInvoice invoice, ALMInvoiceEntry entry) {
        if (invoice != null) {
            try {
                invoice.addInvoiceEntry(entry);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot add an entry to the ALM invoice:", (Throwable)ex);
            }
        } else {
            OrderMate.LOG.warn("Cannot process line entry, do not have a current invoice:" + entry.getLineNum());
        }
    }

    private void finishInvoice(ALMInvoice invoice, ALMInvoiceFooter footer) {
        if (footer == null) {
            throw new IllegalStateException("Cannot finalise the ALM invoice, footer is not present.");
        }
        if (invoice != null) {
            invoice.finaliseInvoice(footer);
            this.receivedInvoices.add(invoice);
        }
    }

    public List<ALMInvoice> getInvoices() {
        return this.receivedInvoices;
    }
}

