/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.invoicing.alm.invoice;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

enum ALMItemType {
    Wine("1", "Wine"),
    Spirits("2", "Spirits"),
    LowB("3", "Low Beer"),
    Beer("4", "Beer"),
    Spare("5", "Spare"),
    LowW("6", "Low Wine"),
    Conf("C", "Confection"),
    Var("V", "Variety"),
    Tob("T", "Tobacco"),
    Soft("S", "Soft Drink"),
    Groc("G", "Grocery"),
    Store("X", "Store Equipment"),
    Deli("A", "Deli"),
    Meat("B", "Fresh Meat"),
    Dairy("D", "Dairy"),
    Freeze("F", "Freezer");

    private static Map<String, ALMItemType> indexMap;
    private final String index;
    private final String label;

    private ALMItemType(String indexValue, String labelValue) {
        this.index = indexValue;
        this.label = labelValue;
    }

    public String getIndex() {
        return this.index;
    }

    public String getLabel() {
        return this.label;
    }

    public static Map<String, ALMItemType> getIndexMap() {
        return Collections.unmodifiableMap(indexMap);
    }

    static {
        indexMap = new HashMap<String, ALMItemType>();
        for (ALMItemType status : ALMItemType.values()) {
            indexMap.put(status.index, status);
        }
    }
}

