/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.invoicing.alm.invoice;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

enum ALMOrderType {
    Normal(" ", "Normal Order"),
    Alloc("A", "Allocation"),
    Bonus("B", "Bonus Stock"),
    Invest("I", "Investment"),
    PriceOver("O", "Price Override");

    private static Map<String, ALMOrderType> indexMap;
    private final String index;
    private final String label;

    private ALMOrderType(String indexValue, String labelValue) {
        this.index = indexValue;
        this.label = labelValue;
    }

    public String getIndex() {
        return this.index;
    }

    public String getLabel() {
        return this.label;
    }

    public static Map<String, ALMOrderType> getIndexMap() {
        return Collections.unmodifiableMap(indexMap);
    }

    static {
        indexMap = new HashMap<String, ALMOrderType>();
        for (ALMOrderType status : ALMOrderType.values()) {
            indexMap.put(status.index, status);
        }
    }
}

