/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.invoicing.alm.invoice;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.config.Quantity;
import ordermate.database.integration.InvoiceIntegrationConfig;
import ordermate.database.stock.StockInvoice;
import ordermate.database.stock.StockInvoiceEntry;
import ordermate.database.stock.StockItem;
import ordermate.integration.invoicing.ExternalInvoiceResolver;
import ordermate.integration.invoicing.InvoiceImportException;
import ordermate.integration.invoicing.InvoiceImportResult;
import ordermate.integration.invoicing.alm.invoice.ALMInvoice;
import ordermate.integration.invoicing.alm.invoice.ALMInvoiceEntry;
import ordermate.integration.invoicing.alm.invoice.ALMInvoiceFooter;
import ordermate.integration.invoicing.alm.invoice.ALMInvoiceHeader;
import ordermate.integration.invoicing.alm.invoice.ALMOrderType;

public class ALMToStockInvoiceConverter {
    private ExternalInvoiceResolver stockResolver;
    private InvoiceIntegrationConfig invoiceConfig;
    private GuiHandler guiHandler;

    public ALMToStockInvoiceConverter(ExternalInvoiceResolver resolver, GuiHandler guiHandler) {
        this.stockResolver = resolver;
        this.invoiceConfig = InvoiceIntegrationConfig.getConfigForType(InvoiceIntegrationConfig.InvoiceIntegrationType.ALM);
        this.guiHandler = guiHandler;
    }

    public StockInvoice convertToInvoice(ALMInvoice invoice) throws InvoiceImportException {
        if (invoice == null) {
            throw new InvoiceImportException("Unknown", InvoiceImportResult.UNKNOWN);
        }
        if (!invoice.isComplete()) {
            if (invoice.getInvoiceHeader() != null) {
                throw new InvoiceImportException(Integer.toString(invoice.getInvoiceHeader().getInvoiceNum()), InvoiceImportResult.INVOICE_INCOMPLETE);
            }
            throw new InvoiceImportException("Unknown", InvoiceImportResult.INVOICE_INCOMPLETE);
        }
        StockInvoice stockInvoice = this.doConvert(invoice);
        if (this.isValid(stockInvoice, invoice)) {
            return stockInvoice;
        }
        return null;
    }

    private StockInvoice doConvert(ALMInvoice invoice) throws InvoiceImportException {
        StockInvoice stockInvoice = new StockInvoice();
        ALMInvoiceFooter footer = invoice.getInvoiceFooter();
        ALMInvoiceHeader header = invoice.getInvoiceHeader();
        stockInvoice.setAdminCost(footer.getAdminFee().add(footer.getFinanceFee()));
        stockInvoice.setDate(header.getInvoiceDate());
        stockInvoice.setDiscount(Price.ZERO_DOLLAR);
        stockInvoice.setExpectedTotal(footer.getInvoiceTotal());
        stockInvoice.setFreightCost(footer.getDeliveryFee().add(footer.getShrinkWrap()));
        stockInvoice.setInvoiceNumber(Integer.toString(footer.getInvoiceNumber()));
        stockInvoice.setInvoiceType("Invoice");
        stockInvoice.setOrderNumber(header.getOrderNum());
        stockInvoice.setStockArea(this.invoiceConfig.getStockArea());
        stockInvoice.setSupplier(this.invoiceConfig.getSupplier());
        ArrayList<StockInvoiceEntry> bonusItems = new ArrayList<StockInvoiceEntry>();
        for (ALMInvoiceEntry entry : invoice.getInvoiceEntries()) {
            StockInvoiceEntry invoiceEntry = this.convertALMToStockInvoiceEntry(entry);
            if (invoiceEntry != null) {
                if (ALMOrderType.Bonus.equals((Object)entry.getOrderType())) {
                    bonusItems.add(invoiceEntry);
                    continue;
                }
                stockInvoice.addEntry(invoiceEntry);
                continue;
            }
            throw new InvoiceImportException(Integer.toString(header.getInvoiceNum()), InvoiceImportResult.USER_CANCELLED);
        }
        this.mergeBonusStockItems(stockInvoice, bonusItems);
        return stockInvoice;
    }

    private StockInvoiceEntry getStockEntryLinkedToBonus(StockInvoice stockInvoice, StockInvoiceEntry bonusItem) {
        List<StockInvoiceEntry> stockItems = stockInvoice.getEntries();
        for (StockInvoiceEntry stockEntry : stockItems) {
            if (!stockEntry.getStockItem().equals(bonusItem.getStockItem())) continue;
            return stockEntry;
        }
        return null;
    }

    private void mergeBonusStockItems(StockInvoice stockInvoice, List<StockInvoiceEntry> bonusItems) {
        for (StockInvoiceEntry bonusItem : bonusItems) {
            StockInvoiceEntry stockItem = this.getStockEntryLinkedToBonus(stockInvoice, bonusItem);
            if (stockItem != null) {
                stockItem.setBonusReceived(stockItem.getBonusReceived() + bonusItem.getBonusReceived());
                stockItem.getPricePaid().add(bonusItem.getPricePaid());
                continue;
            }
            stockInvoice.addEntry(bonusItem);
        }
    }

    private StockInvoiceEntry convertALMToStockInvoiceEntry(ALMInvoiceEntry entry) {
        StockInvoiceEntry stockEntry = new StockInvoiceEntry();
        stockEntry.setBonusReceived(ALMOrderType.Bonus.equals((Object)entry.getOrderType()) ? (double)entry.getUnitsSupplied() : 0.0);
        stockEntry.setTaxIncluded(true);
        stockEntry.setNumReceived(ALMOrderType.Bonus.equals((Object)entry.getOrderType()) ? 0.0 : (double)entry.getUnitsSupplied());
        stockEntry.setOverridesCost(false);
        stockEntry.setPricePaid(entry.getExtendedWholesale());
        StockItem prototype = this.createStockItemPrototype(entry);
        StockItem item = this.stockResolver.findStockForExternalId(prototype);
        if (item != null) {
            stockEntry.setStockItem(item);
            return stockEntry;
        }
        return null;
    }

    private StockItem createStockItemPrototype(ALMInvoiceEntry entry) {
        StockItem item = new StockItem();
        item.setLabel(entry.getProductDesc());
        item.setOuterQuantity(entry.getWholesalePackQty() != 0 ? (double)entry.getWholesalePackQty() : 1.0);
        long barcode = entry.getAPNCode();
        if (barcode > 0L) {
            item.addBarcode(Long.toString(barcode));
        }
        item.setExtId(Long.valueOf(entry.getItemNumber()));
        item.setPurchaseQty(new Quantity(1.0));
        if (entry.getUnitsSupplied() != 0) {
            item.setCurrentCost(entry.getBasePrice().divide(entry.getUnitsSupplied()));
        } else {
            item.setCurrentCost(entry.getBasePrice());
        }
        if (this.invoiceConfig.getSupplier() != null) {
            item.addSupplier(this.invoiceConfig.getSupplier());
        }
        return item;
    }

    private boolean isValid(StockInvoice stockInvoice, ALMInvoice invoice) throws InvoiceImportException {
        if (stockInvoice != null && invoice != null) {
            return this.validateCustomerCode(invoice);
        }
        return false;
    }

    private boolean validateCustomerCode(ALMInvoice invoice) throws InvoiceImportException {
        boolean result;
        if (!this.invoiceConfig.getCustomerNo().equals(Integer.toString(invoice.getInvoiceHeader().getCustomerCode())) && !(result = this.guiHandler.displayForcedChoiceDialog("Customer Number Does Not Match", "The Customer No (" + invoice.getInvoiceHeader().getCustomerCode() + ") for Invoice (" + invoice.getInvoiceHeader().getInvoiceNum() + ") \ndoes not match the expected Customer No (" + this.invoiceConfig.getCustomerNo() + ").\n\nDo you wish to still import this Invoice?", "", ""))) {
            throw new InvoiceImportException(Integer.toString(invoice.getInvoiceHeader().getInvoiceNum()), InvoiceImportResult.INVALID_CUSTOMER_CODE);
        }
        return true;
    }
}

