/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.invoicing.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockInvoice;
import ordermate.integration.invoicing.ExternalInvoiceResolver;
import ordermate.integration.invoicing.csv.CsvStockInvoiceParser;
import ordermate.integration.invoicing.csv.StringPropertyMapper;
import ordermate.integration.invoicing.csv.converter.PropertyConverter;

public abstract class CsvStockInvoiceIntegration {
    private StringPropertyMapper importer;
    private char separatorChar = (char)44;
    private char quoteChar = (char)34;
    private ExternalInvoiceResolver resolver;

    public CsvStockInvoiceIntegration(ExternalInvoiceResolver resolver) {
        this.importer = this.createImporter();
        this.resolver = resolver;
    }

    protected ExternalInvoiceResolver getResolver() {
        return this.resolver;
    }

    public List<StockInvoice> importCsv(String file) throws FileNotFoundException, IOException {
        return this.importCsv(new File(file));
    }

    public List<StockInvoice> importCsv(File file) throws FileNotFoundException, IOException {
        FileReader fileReader = new FileReader(file);
        CSVReader csvReader = new CSVReader((Reader)fileReader, this.getSeparatorChar(), this.getQuoteChar());
        String[] headers = csvReader.readNext();
        if (headers[0].endsWith("Supplier Name")) {
            headers[0] = "Supplier Name";
        }
        PropertyConverter[] converters = this.loadConverters(headers);
        CsvStockInvoiceParser invoiceParser = this.createParser(converters);
        List<StockInvoice> invoices = invoiceParser.readInInvoices(csvReader);
        for (StockInvoice invoice : invoices) {
            if (invoice.getStockArea() != null) continue;
            invoice.setStockArea(this.getDefaultStockArea());
        }
        csvReader.close();
        return invoices;
    }

    protected CsvStockInvoiceParser createParser(PropertyConverter[] converters) {
        return new CsvStockInvoiceParser(converters, this.getResolver());
    }

    private PropertyConverter[] loadConverters(String[] headers) {
        PropertyConverter[] converters = new PropertyConverter[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            converters[i] = this.importer.getConverterMap().get(headers[i]);
            if (converters[i] != null) continue;
            OrderMate.LOG.warn("Haven't got a converter for :" + headers[i]);
        }
        return converters;
    }

    public char getSeparatorChar() {
        return this.separatorChar;
    }

    public void setSeparatorChar(char value) {
        this.separatorChar = value;
    }

    public char getQuoteChar() {
        return this.quoteChar;
    }

    public void setQuoteChar(char value) {
        this.quoteChar = value;
    }

    protected abstract StockArea getDefaultStockArea();

    protected abstract StringPropertyMapper createImporter();
}

