/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.invoicing.csv;

import au.com.bytecode.opencsv.CSVReader;
import au.com.ordermate.persistence.PropertiedObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.stock.StockInvoice;
import ordermate.database.stock.StockInvoiceEntry;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockItemSupplier;
import ordermate.database.stock.StockSupplier;
import ordermate.integration.invoicing.ExternalInvoiceResolver;
import ordermate.integration.invoicing.csv.converter.PropertyConverter;

public class CsvStockInvoiceParser {
    private Map<String, StockInvoice> invoiceMap;
    private Map<PropertiedObject.Property, Integer> propertyIndexMap;
    private PropertyConverter[] converters;
    private ExternalInvoiceResolver resolver;

    public CsvStockInvoiceParser(PropertyConverter[] converters, ExternalInvoiceResolver resolver) {
        this.converters = converters;
        this.resolver = resolver;
        this.invoiceMap = new LinkedHashMap<String, StockInvoice>();
        this.propertyIndexMap = new HashMap<PropertiedObject.Property, Integer>();
        for (int i = 0; i < converters.length; ++i) {
            if (converters[i] == null) continue;
            this.propertyIndexMap.put(converters[i].getProperty(), i);
        }
    }

    List<StockInvoice> readInInvoices(CSVReader reader) throws IOException {
        String[] data = reader.readNext();
        while (data != null) {
            if (data.length > 1) {
                this.parseData(data);
            }
            data = reader.readNext();
        }
        ArrayList<StockInvoice> invoices = new ArrayList<StockInvoice>();
        for (String nextKey : this.invoiceMap.keySet()) {
            if (this.invoiceMap.get(nextKey) == null) continue;
            invoices.add(this.invoiceMap.get(nextKey));
        }
        return invoices;
    }

    private void parseData(String[] data) {
        Object[] dataValues = new Object[data.length];
        for (int i = 0; i < data.length; ++i) {
            PropertyConverter converter = this.converters[i];
            if (converter == null) continue;
            dataValues[i] = converter.convertValueFromString(data[i]);
        }
        StockInvoice invoice = this.getInvoice(dataValues);
        if (invoice != null) {
            try {
                this.readInvoiceEntry(invoice, dataValues);
            }
            catch (Exception ex) {
                String key = null;
                for (String nextKey : this.invoiceMap.keySet()) {
                    if (invoice != this.invoiceMap.get(nextKey)) continue;
                    key = nextKey;
                }
                this.invoiceMap.put(key, null);
                OrderMate.LOG.error("Cannot read invoice, will skip.", (Throwable)ex);
            }
        }
    }

    private StockInvoice getInvoice(Object[] data) {
        StockSupplier supplier = new StockSupplier();
        this.loadProperties(supplier, data);
        supplier = this.resolver.resolveSupplier(supplier);
        if (supplier == null) {
            return null;
        }
        String orderNumber = this.propertyValue(data, StockInvoice.Properties.ORDER_NUMBER);
        String invoiceNumber = this.propertyValue(data, StockInvoice.Properties.INVOICE_NUMBER);
        StringBuilder SB = new StringBuilder();
        SB.append(supplier.getLabel()).append("-").append(orderNumber).append("-").append(invoiceNumber);
        String key = SB.toString();
        if (!this.invoiceMap.containsKey(key)) {
            StockInvoice invoice = new StockInvoice();
            invoice.setSupplier(supplier);
            this.loadProperties(invoice, data);
            this.invoiceMap.put(key, invoice);
        }
        return this.invoiceMap.get(key);
    }

    private void readInvoiceEntry(StockInvoice invoice, Object[] data) {
        StockInvoiceEntry entry = new StockInvoiceEntry();
        this.loadProperties(entry, data);
        String supplierItemCode = this.propertyValue(data, StockItemSupplier.Properties.PRODUCT_CODE);
        StockSupplier supplier = invoice.getSupplier();
        StockItem prototype = new StockItem();
        this.loadProperties(prototype, data);
        StockItem item = this.resolver.findStockItemForSupplierCode(prototype, supplier, supplierItemCode);
        if (item == null) {
            String error = "Cannot resolve stock item for " + supplierItemCode + " for supplier " + supplier;
            OrderMate.LOG.warn(error);
            return;
        }
        entry.setStockItem(item);
        this.configureEntry(data, entry);
        invoice.addEntry(entry);
    }

    protected void configureEntry(Object[] data, StockInvoiceEntry entry) {
    }

    protected <T> T propertyValue(Object[] data, PropertiedObject.Property<T> property) {
        Integer value = this.propertyIndexMap.get(property);
        if (value != null) {
            return (T)data[value];
        }
        throw new IllegalStateException("We must have a converter for the given property:" + property);
    }

    protected <T> T safePropertyValue(Object[] data, PropertiedObject.Property<T> property, T defaultValue) {
        Integer value = this.propertyIndexMap.get(property);
        if (value != null) {
            return (T)data[value];
        }
        return defaultValue;
    }

    private void loadProperties(PropertiedObject object, Object[] data) {
        for (PropertyConverter converter : this.converters) {
            PropertiedObject.Property prop;
            if (converter == null || !(prop = converter.getProperty()).getOwner().equals(object.getClass())) continue;
            converter.setPropertyValue(object, this.propertyValue(data, prop));
        }
    }
}

