/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.invoicing.csv.converter;

import au.com.ordermate.persistence.PropertiedObject;
import ordermate.OrderMate;
import ordermate.integration.invoicing.csv.converter.PropertyConverter;

public abstract class AbstractPropertyConverter<T>
implements PropertyConverter<T> {
    private final PropertiedObject.Property prop;
    private T blankValue = null;
    private boolean trimString = true;
    Class actualReturn = null;

    public AbstractPropertyConverter(PropertiedObject.Property property) {
        this.prop = property;
    }

    public void setBlankValue(T value) {
        this.blankValue = value;
    }

    public void setTrimString(boolean value) {
        this.trimString = value;
    }

    @Override
    public PropertiedObject.Property getProperty() {
        return this.prop;
    }

    protected Class getPropertyType() {
        if (this.actualReturn == null) {
            this.actualReturn = this.prop.getObjectType();
        }
        return this.actualReturn;
    }

    @Override
    public T convertValueFromString(String value) {
        if (value == null) {
            return null;
        }
        String newValue = value;
        if (this.trimString) {
            newValue = newValue.trim();
        }
        if (newValue.isEmpty()) {
            return this.blankValue;
        }
        try {
            return this.createValueForString(newValue);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot convert property:" + this.prop + " for value " + value);
            return this.blankValue;
        }
    }

    protected abstract T createValueForString(String var1);

    @Override
    public void setPropertyValue(PropertiedObject object, T propertyValue) {
        PropertiedObject.PropsHelper.setPropertyValue(object, this.prop, propertyValue);
    }

    public String toString() {
        StringBuilder SB = new StringBuilder(this.prop.getOwner().getName());
        SB.append(" ").append(this.prop.getName());
        return SB.toString();
    }
}

