/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.invoicing.csv.converter;

import au.com.ordermate.persistence.PropertiedObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import ordermate.OrderMate;
import ordermate.integration.invoicing.csv.converter.AbstractPropertyConverter;

public class DatePropertyConverter
extends AbstractPropertyConverter<Date> {
    private SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");

    public DatePropertyConverter(PropertiedObject.Property property) {
        super(property);
    }

    public void setDateFormat(String dateFormat) {
        if (dateFormat != null && !dateFormat.trim().isEmpty()) {
            this.format = new SimpleDateFormat(dateFormat);
        }
    }

    @Override
    protected Date createValueForString(String value) {
        try {
            return this.format.parse(value);
        }
        catch (ParseException e) {
            OrderMate.LOG.error("Cannot parse date format");
            return null;
        }
    }
}

