/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.invoicing.csv.converter;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.integration.invoicing.csv.converter.BooleanPropertyConverter;
import ordermate.integration.invoicing.csv.converter.DatePropertyConverter;
import ordermate.integration.invoicing.csv.converter.NumericPropertyConverter;
import ordermate.integration.invoicing.csv.converter.PassthroughPropertyConverter;
import ordermate.integration.invoicing.csv.converter.PricePropertyConverter;
import ordermate.integration.invoicing.csv.converter.PropertyConverter;

public class DefaultPropertyConverterFactory {
    private Map<Class, Class<? extends PropertyConverter>> typeConversionMap = new HashMap<Class, Class<? extends PropertyConverter>>();

    public DefaultPropertyConverterFactory() {
        this.loadBasicMap(this.typeConversionMap);
    }

    protected void loadBasicMap(Map<Class, Class<? extends PropertyConverter>> map) {
        this.typeConversionMap.put(String.class, PassthroughPropertyConverter.class);
        this.typeConversionMap.put(Number.class, NumericPropertyConverter.class);
        this.typeConversionMap.put(Boolean.class, BooleanPropertyConverter.class);
        this.typeConversionMap.put(Price.class, PricePropertyConverter.class);
        this.typeConversionMap.put(Date.class, DatePropertyConverter.class);
        this.typeConversionMap.put(Double.TYPE, NumericPropertyConverter.class);
    }

    public void registerClassConverter(Class clazz, Class converterClazz) {
        this.typeConversionMap.put(clazz, converterClazz);
    }

    public PropertyConverter createPropertyConverter(PropertiedObject.Property property) {
        Class<? extends PropertyConverter> converterClazz = null;
        Class currentClazz = property.getType();
        while (converterClazz == null && currentClazz != null) {
            converterClazz = this.typeConversionMap.get(currentClazz);
            if (converterClazz != null) continue;
            currentClazz = currentClazz.getSuperclass();
        }
        if (converterClazz == null) {
            throw new IllegalStateException("Cannot find conversion class for property Type:" + property);
        }
        try {
            return converterClazz.getConstructor(PropertiedObject.Property.class).newInstance(property);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot create instance of PropertyConverter:" + converterClazz, (Throwable)ex);
            throw new IllegalStateException("Cannot create instance of PropertyConverter::" + converterClazz);
        }
    }
}

