/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.invoicing.csv.converter;

import au.com.ordermate.persistence.PropertiedObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import ordermate.integration.invoicing.csv.converter.AbstractPropertyConverter;

public class NumericPropertyConverter
extends AbstractPropertyConverter<Number> {
    private final Class clazz = this.getPropertyType();

    public NumericPropertyConverter(PropertiedObject.Property<? extends Number> property) {
        super(property);
    }

    @Override
    protected Number createValueForString(String value) {
        if (this.clazz.isPrimitive()) {
            if (Integer.TYPE.equals(this.clazz)) {
                return Integer.valueOf(value);
            }
            if (Double.TYPE.equals(this.clazz)) {
                return Double.valueOf(value);
            }
            if (Long.TYPE.equals(this.clazz)) {
                return Long.valueOf(value);
            }
            throw new IllegalArgumentException("Cannot convert String to clazz:" + this.clazz + " for value " + value);
        }
        if (Integer.class.equals((Object)this.clazz)) {
            return Integer.valueOf(value);
        }
        if (Long.class.equals((Object)this.clazz)) {
            return Long.valueOf(value);
        }
        if (Double.class.equals((Object)this.clazz)) {
            return Double.valueOf(value);
        }
        if (BigDecimal.class.equals((Object)this.clazz)) {
            return BigDecimal.valueOf(Double.parseDouble(value));
        }
        if (BigInteger.class.equals((Object)this.clazz)) {
            return BigInteger.valueOf(Long.parseLong(value));
        }
        throw new IllegalArgumentException("Cannot convert String to clazz:" + this.clazz + " for value " + value);
    }

    @Override
    public void setPropertyValue(PropertiedObject object, Number propertyValue) {
        if (this.clazz.isPrimitive()) {
            if (propertyValue == null) {
                throw new IllegalArgumentException("Cannot pass a null reference to a primitive:" + this.getProperty());
            }
            if (Integer.TYPE.equals(this.clazz)) {
                PropertiedObject.PropsHelper.setPropertyValue(object, this.getProperty(), propertyValue);
            } else if (Long.TYPE.equals(this.clazz)) {
                PropertiedObject.PropsHelper.setPropertyValue(object, this.getProperty(), propertyValue.longValue());
            } else if (Double.TYPE.equals(this.clazz)) {
                PropertiedObject.PropsHelper.setPropertyValue(object, this.getProperty(), propertyValue.doubleValue());
            } else if (Float.TYPE.equals(this.clazz)) {
                PropertiedObject.PropsHelper.setPropertyValue(object, this.getProperty(), Float.valueOf(propertyValue.floatValue()));
            }
        }
        super.setPropertyValue(object, propertyValue);
    }
}

