/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.invoicing.invitbox;

import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.Price;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.misc.SystemProperty;
import ordermate.database.stock.StockInvoiceEntry;
import ordermate.database.stock.StockItem;
import ordermate.integration.invoicing.ExternalInvoiceResolver;
import ordermate.integration.invoicing.csv.CsvStockInvoiceParser;
import ordermate.integration.invoicing.csv.converter.PropertyConverter;

class InvitBoxCsvParser
extends CsvStockInvoiceParser {
    InvitBoxCsvParser(PropertyConverter[] converters, ExternalInvoiceResolver resolver) {
        super(converters, resolver);
    }

    @Override
    protected void configureEntry(Object[] data, StockInvoiceEntry entry) {
        StockItem item = entry.getStockItem();
        entry.setTaxIncluded(true);
        entry.setNumReceived(this.getTotalNumUnitsReceived(data));
        if (item != null) {
            Price price = this.propertyValue(data, StockInvoiceEntry.Properties.PRICE_PAID);
            if (item.isTaxIncluded()) {
                entry.setPricePaid(FinanceUtils.addTax(price, SystemProperty.getInstance().getBaseTaxRate()));
            } else {
                entry.setTaxIncluded(false);
            }
        }
    }

    private double getTotalNumUnitsReceived(Object[] data) {
        Double cases = this.safePropertyValue(data, StockItem.Properties.OUTER_QUANTITY, 0.0);
        Double caseSize = this.safePropertyValue(data, MeasureUnitContainer.Properties.QUANTITY_PER_CONTAINER, 0.0);
        Double units = this.propertyValue(data, StockInvoiceEntry.Properties.NUM_RECEIVED);
        return cases * caseSize + units;
    }
}

