/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.invoicing.lightyear;

import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.Price;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.misc.SystemProperty;
import ordermate.database.stock.StockInvoiceEntry;
import ordermate.database.stock.StockItem;
import ordermate.integration.invoicing.ExternalInvoiceResolver;
import ordermate.integration.invoicing.csv.CsvStockInvoiceParser;
import ordermate.integration.invoicing.csv.converter.PropertyConverter;

class LightYearCsvParser
extends CsvStockInvoiceParser {
    LightYearCsvParser(PropertyConverter[] converters, ExternalInvoiceResolver resolver) {
        super(converters, resolver);
    }

    @Override
    protected void configureEntry(Object[] data, StockInvoiceEntry entry) {
        StockItem item = entry.getStockItem();
        entry.setTaxIncluded(false);
        entry.setNumReceived(this.getTotalNumUnitsReceived(data));
        if (item != null) {
            Price pricePerUnit = this.propertyValue(data, StockInvoiceEntry.Properties.PRICE_PAID_PER_UNIT);
            if (item.isTaxIncluded()) {
                entry.setPricePaidPerUnit(FinanceUtils.addTax(pricePerUnit, SystemProperty.getInstance().getBaseTaxRate()));
                entry.setTaxIncluded(true);
            } else {
                entry.setTaxIncluded(false);
            }
        }
    }

    private double getTotalNumUnitsReceived(Object[] data) {
        Double cases = this.safePropertyValue(data, StockItem.Properties.OUTER_QUANTITY, 0.0);
        Double caseSize = this.safePropertyValue(data, MeasureUnitContainer.Properties.QUANTITY_PER_CONTAINER, 0.0);
        Double units = this.safePropertyValue(data, StockInvoiceEntry.Properties.NUM_RECEIVED, 0.0);
        return cases * caseSize + units;
    }
}

