/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.liquorfile.comparison;

import au.com.ordermate.util.Price;
import ordermate.OrderMate;
import ordermate.integration.liquorfile.scandata.ScandataInterface;

public class ScandataComparison {
    private String item;
    private Price total;
    private Price price;
    private Double qty;
    private ScandataInterface reportObject;

    public ScandataComparison(ScandataInterface scandataReportObject) {
        this.reportObject = scandataReportObject;
        this.item = null;
        this.total = null;
        this.price = null;
        this.qty = null;
    }

    public ScandataComparison(String unitItem, String unitPrice, String unitTotal, String unitQty) {
        this.item = unitItem;
        if (unitPrice == null) {
            this.price = null;
        } else {
            try {
                this.price = Price.parsePrice(unitPrice);
            }
            catch (NumberFormatException ex) {
                OrderMate.LOG.warn("Number format exception while comparing " + unitItem, (Throwable)ex);
            }
        }
        this.total = unitTotal == null ? null : Price.parsePrice(unitTotal);
        this.qty = Double.valueOf(unitQty);
    }

    public String getItem() {
        return this.item;
    }

    public void setItem(String value) {
        this.item = value;
    }

    public Price getTotal() {
        return this.total;
    }

    public void setTotal(Price value) {
        this.total = value;
    }

    public Price getPrice() {
        return this.price;
    }

    public void setPrice(Price value) {
        this.price = value;
    }

    public Double getQty() {
        return this.qty;
    }

    public void setQty(Double value) {
        this.qty = value;
    }

    public ScandataInterface getReportObject() {
        return this.reportObject;
    }

    public void setReportObject(ScandataInterface value) {
        this.reportObject = value;
    }
}

