/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.liquorfile.comparison;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.misc.TradingDay;
import ordermate.integration.csv.CSVExporter;
import ordermate.integration.liquorfile.comparison.ScandataComparison;
import ordermate.integration.liquorfile.comparison.ScandataSalesReportComparisonMapping;
import ordermate.integration.liquorfile.scandata.PersistentScandata;
import ordermate.integration.liquorfile.scandata.ScandataInterface;
import ordermate.integration.liquorfile.scandata.ScandataManager;

public class ScandataExportComparator {
    private static final String QTY_HEADER = "Quantity Sold";
    private static final String PRICE_HEADER = "Unit Price";
    private static final String ITEM_HEADER = "Item";
    private static final String TOTAL_VALUE_HEADER = "Takings";
    private static final ScandataManager scandataManager = new ScandataManager();

    public static boolean compareExports(String exportFile, String csvFileToCompare, TradingDay toCompare) {
        ArrayList<ScandataComparison> finalList;
        boolean fine = true;
        List listOfExpected = ScandataExportComparator.importCSV(new File(csvFileToCompare));
        ArrayList<PersistentScandata> scandataExports = new ArrayList<PersistentScandata>();
        scandataExports.addAll(scandataManager.getScandataExport(toCompare).getScandataEntries());
        if (listOfExpected == null || scandataExports == null) {
            fine = false;
            finalList = null;
        } else {
            finalList = new ArrayList<ScandataComparison>();
            Iterator it = listOfExpected.iterator();
            boolean found = false;
            while (it.hasNext()) {
                ScandataComparison nextComp = (ScandataComparison)it.next();
                for (ScandataInterface scandataInterface : scandataExports) {
                    if (!scandataInterface.getUnitDesc().equals(nextComp.getItem())) continue;
                    nextComp.setReportObject(scandataInterface);
                    scandataExports.remove(scandataInterface);
                    finalList.add(nextComp);
                    found = true;
                    break;
                }
                if (found) continue;
                finalList.add(nextComp);
            }
            Iterator remaining = scandataExports.iterator();
            while (remaining.hasNext()) {
                finalList.add(new ScandataComparison((ScandataInterface)remaining.next()));
            }
        }
        if (finalList != null) {
            try {
                ScandataExportComparator.writeOutFile(finalList, exportFile);
            }
            catch (IOException ex) {
                fine = false;
            }
        }
        return fine;
    }

    private static List importCSV(File file) {
        ArrayList<ScandataComparison> listOfExpected = new ArrayList<ScandataComparison>();
        if (file == null) {
            throw new NullPointerException("Cannot read in a null file.");
        }
        try {
            CSVReader reader = new CSVReader((Reader)new BufferedReader(new FileReader(file)));
            String[] header = reader.readNext();
            int itemCol = ScandataExportComparator.findColumn(ITEM_HEADER, header);
            int qtyCol = ScandataExportComparator.findColumn(QTY_HEADER, header);
            int priceCol = ScandataExportComparator.findColumn(PRICE_HEADER, header);
            int totalCol = ScandataExportComparator.findColumn(TOTAL_VALUE_HEADER, header);
            if (itemCol == -1 || qtyCol == -1 || priceCol == -1 || totalCol == -1) {
                throw new IllegalArgumentException("Liquorfile ID columns are corrupt, itemCol: " + itemCol + ", qtyCol:" + qtyCol + " priceCol:" + priceCol + " totalCol:" + totalCol);
            }
            String[] data = reader.readNext();
            while (data != null) {
                listOfExpected.add(new ScandataComparison(data[itemCol], data[priceCol], data[totalCol], data[qtyCol]));
                data = reader.readNext();
            }
        }
        catch (IOException ex) {
            listOfExpected = null;
            OrderMate.LOG.warn("Problem reading the Scandata Comparison input file.", (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            listOfExpected = null;
            OrderMate.LOG.error("Problem reading the Scandata Comparison input file.", (Throwable)ex);
        }
        return listOfExpected;
    }

    private static int findColumn(String columnToFind, String[] csvHeader) {
        int index = -1;
        for (int i = 0; i < csvHeader.length; ++i) {
            if (!columnToFind.equalsIgnoreCase(csvHeader[i])) continue;
            index = i;
            i = csvHeader.length;
        }
        return index;
    }

    private static void writeOutFile(List listToWrite, String fileName) throws IOException {
        if (listToWrite == null) {
            throw new NullPointerException("Cannot export a null list.");
        }
        if (fileName == null) {
            throw new NullPointerException("Cannot export to a null file.");
        }
        if (fileName.trim().length() == 0) {
            throw new IllegalArgumentException("Cannot export to an empty-named file.");
        }
        CSVExporter exporter = new CSVExporter(new ScandataSalesReportComparisonMapping(listToWrite));
        File file = new File(fileName);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new IllegalArgumentException("Cannot create parent directory, bad or no permission:" + file.getParentFile());
        }
        exporter.createExportFile(fileName);
    }
}

