/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.liquorfile.comparison;

import au.com.ordermate.util.Price;
import java.util.List;
import ordermate.integration.exportmapping.ExportTemplate;
import ordermate.integration.exportmapping.SimpleMapping;
import ordermate.integration.liquorfile.comparison.ScandataComparison;
import ordermate.integration.liquorfile.comparison.ScandataSalesReportComparisonTemplate;

public class ScandataSalesReportComparisonMapping
extends SimpleMapping {
    private ScandataSalesReportComparisonTemplate template;

    public ScandataSalesReportComparisonMapping(List scandataComparisons) {
        super(scandataComparisons);
    }

    @Override
    protected void initMapping() {
        super.initMapping();
        this.template = new ScandataSalesReportComparisonTemplate();
        this.addMapping(this.template.item, this.createAccessor("getItem"));
        this.addMapping(this.template.LFID, this.createAccessor("getLFID"));
        this.addMapping(this.template.qty, this.createAccessor("getQty"));
        this.addMapping(this.template.SD_qty, this.createAccessor("getSDQty"));
        this.addMapping(this.template.value, this.createAccessor("getValue"));
        this.addMapping(this.template.SD_value, this.createAccessor("getSDValue"));
        this.addMapping(this.template.total, this.createAccessor("getTotal"));
        this.addMapping(this.template.SD_total, this.createAccessor("getSDTotal"));
        this.addMapping(this.template.matched, this.createAccessor("isMatched"));
        this.addMapping(this.template.agree, this.createAccessor("isAgree"));
    }

    public String getItem(ScandataComparison comparison) {
        if (comparison.getReportObject() != null) {
            return comparison.getReportObject().getUnitDesc();
        }
        return comparison.getItem();
    }

    public String getLFID(ScandataComparison comparison) {
        if (comparison.getReportObject() != null && comparison.getReportObject().getLiquorfileId() != null) {
            return comparison.getReportObject().getLiquorfileId().toString();
        }
        return null;
    }

    public String getQty(ScandataComparison comparison) {
        if (comparison.getQty() != null) {
            return comparison.getQty().toString();
        }
        return "";
    }

    public String getSDQty(ScandataComparison comparison) {
        if (comparison.getReportObject() != null) {
            return comparison.getReportObject().getQtySold().toString();
        }
        return "";
    }

    public String getValue(ScandataComparison comparison) {
        if (comparison.getPrice() != null) {
            return comparison.getPrice().toString();
        }
        return "";
    }

    public String getSDValue(ScandataComparison comparison) {
        if (comparison.getReportObject() != null) {
            return new Price(comparison.getReportObject().getSellingPrice(), 1.0E-4).toString();
        }
        return "";
    }

    public String getTotal(ScandataComparison comparison) {
        if (comparison.getTotal() != null) {
            return comparison.getTotal().toString();
        }
        return "";
    }

    public String getSDTotal(ScandataComparison comparison) {
        if (comparison.getReportObject() != null) {
            return new Price(comparison.getReportObject().getValueSold().toString(), 1.0E-4).toString();
        }
        return "";
    }

    public boolean isMatched(ScandataComparison comparison) {
        return comparison.getReportObject() != null && comparison.getQty() != null;
    }

    public boolean isAgree(ScandataComparison comparison) {
        boolean agreed;
        if (comparison.getReportObject() == null || comparison.getQty() == null || comparison.getTotal() == null || comparison.getPrice() == null) {
            agreed = false;
        } else {
            double priceDif = Math.abs(comparison.getPrice().doubleValue() - comparison.getReportObject().getSellingPrice().doubleValue());
            double totalDif = Math.abs(comparison.getTotal().doubleValue() - comparison.getReportObject().getValueSold().doubleValue());
            double qtyDif = comparison.getQty() - comparison.getReportObject().getQtySold();
            agreed = priceDif <= 0.01 && totalDif <= 0.01 && qtyDif == 0.0;
        }
        return agreed;
    }

    @Override
    protected Class getBusinessObjectClass() {
        return ScandataComparison.class;
    }

    @Override
    protected ExportTemplate getTemplate() {
        return this.template;
    }
}

