/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.liquorfile.manager;

import au.com.bytecode.opencsv.CSVReader;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.integration.LiquorfileConfiguration;
import ordermate.integration.csv.CsvImportException;
import ordermate.integration.csv.CsvIterator;
import ordermate.integration.exportmapping.ExportTemplate;
import ordermate.integration.liquorfile.LFDecryptWrapper;
import ordermate.integration.liquorfile.manager.builder.LiquorFileBuilder;
import ordermate.integration.liquorfile.manager.builder.LiquorFileBuilderFactory;
import ordermate.integration.liquorfile.manager.templates.LiquorFileTemplateFactory;

public class LiquorFileManager {
    private static final String FILE_LOCATION = "/ordermate/integration/liquorfile/manager/";
    private static final String PRODUCT_COMP_NAME = "FPRODUCT_";
    private static final String SUPP_ITEM_COMP_NAME = "FSUPPITEM_";
    private static final String SUPPLIER_COMP_NAME = "FSUPPLIER_";
    private static final String APN_COMP_NAME = "FAPN_";
    private static final String GROUP_COMP_NAME = "FGROUP_";
    private static final String CATEGORY_COMP_NAME = "FCATEGORY_";
    private static final String DEPARTMENT_COMP_NAME = "FDEPT_";
    private static final String ZIP_FILE = "LiquorFile.sdz";
    private static LiquorFileManager instance = null;
    private List entries = new ArrayList();
    private LiquorFileTemplateFactory templateFactory = new LiquorFileTemplateFactory();
    private String suffix;
    private String directory;

    private LiquorFileManager() {
    }

    public static LiquorFileManager getInstance() {
        if (instance == null) {
            instance = new LiquorFileManager();
        }
        return instance;
    }

    public boolean installPricebook() {
        boolean success = true;
        if (this.entries.isEmpty()) {
            success = success && this.performDecryption(GROUP_COMP_NAME);
            success = success && this.performDecryption(CATEGORY_COMP_NAME);
            success = success && this.performDecryption(DEPARTMENT_COMP_NAME);
            success = success && this.performDecryption(PRODUCT_COMP_NAME);
            success = success && this.performDecryption(SUPPLIER_COMP_NAME);
            success = success && this.performDecryption(SUPP_ITEM_COMP_NAME);
            success = success && this.performDecryption(APN_COMP_NAME);
        }
        return success;
    }

    private boolean performDecryption(String component) {
        try {
            this.entries.addAll(this.decryptLiquorFileData(component));
        }
        catch (UnsatisfiedLinkError ex) {
            OrderMate.LOG.error("Aborting LiquorFileManager.performDecryption due to UnsatisfiedLinkError");
            return false;
        }
        if (this.entries.isEmpty()) {
            OrderMate.LOG.error("Aborting LiquorFileManager.performDecryption due to no data decrypted");
            return false;
        }
        String filename = this.getPricebookDirectory() + component + this.getBusinessNameSuffix() + ".csv";
        File file = new File(filename);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            StringUtils.writeTextToFile(file, this.buildSingleString(this.entries));
        }
        catch (Exception e) {
            OrderMate.LOG.warn("ERROR writing file" + e);
        }
        List<String[]> dataFromSavedFile = this.openCSVFile(filename);
        this.loadCSVData(component, dataFromSavedFile);
        this.entries.clear();
        return true;
    }

    private String buildSingleString(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String elem : list) {
            sb.append(elem);
        }
        return sb.toString();
    }

    protected Collection decryptLiquorFileData(String component) throws UnsatisfiedLinkError {
        LiquorfileConfiguration LFConfig = LiquorfileConfiguration.getInstance();
        LFConfig = (LiquorfileConfiguration)PersistenceManager.reacquire(LFConfig);
        this.suffix = LFConfig.getPricebookComponentExtension();
        this.directory = LFConfig.getPricebookImportDir();
        LFDecryptWrapper wrapper = new LFDecryptWrapper();
        this.releaseData();
        return wrapper.decryptFile(this.getPricebookDirectory() + ZIP_FILE, component + this.getBusinessNameSuffix() + ".txt");
    }

    public boolean explicitLoadCSVData() {
        boolean success = true;
        ArrayList<String> toLoad = new ArrayList<String>(){
            {
                this.add(LiquorFileManager.GROUP_COMP_NAME);
                this.add(LiquorFileManager.CATEGORY_COMP_NAME);
                this.add(LiquorFileManager.DEPARTMENT_COMP_NAME);
                this.add(LiquorFileManager.SUPPLIER_COMP_NAME);
                this.add(LiquorFileManager.PRODUCT_COMP_NAME);
                this.add(LiquorFileManager.APN_COMP_NAME);
                this.add(LiquorFileManager.SUPP_ITEM_COMP_NAME);
            }
        };
        for (String prefix : toLoad) {
            OrderMate.LOG.info("Loading... File = " + prefix + "SAMPLE.txt");
            List data = new ArrayList();
            InputStream stream = this.getClass().getResourceAsStream(FILE_LOCATION + prefix + "SAMPLE.txt");
            CSVReader csvIn = new CSVReader((Reader)new InputStreamReader(stream));
            try {
                data = csvIn.readAll();
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Unable to load in CSV data for PriceBook: " + prefix + "\n" + ex);
                success = false;
            }
            instance.loadCSVData(prefix, data);
        }
        return success;
    }

    private List<String[]> openCSVFile(String toOpen) {
        OrderMate.LOG.info("Loading... File = " + toOpen);
        List<Object> data = new ArrayList<String[]>();
        File ourCSV = new File(toOpen);
        if (!ourCSV.exists()) {
            data = null;
            return data;
        }
        try {
            CSVReader csvIn = new CSVReader((Reader)new FileReader(ourCSV));
            data = csvIn.readAll();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Unable to load in CSV data for PriceBook: " + toOpen + "\n" + ex);
            data = null;
        }
        return data;
    }

    protected void loadCSVData(String fileCreated, List rows) {
        ExportTemplate template = this.templateFactory.getTemplate(fileCreated);
        try {
            CsvIterator csvIt = new CsvIterator(template, rows);
            this.convertEntries(csvIt, fileCreated);
        }
        catch (CsvImportException ex) {
            OrderMate.LOG.warn("Problem iterating LiquorFile products.", (Throwable)ex);
        }
    }

    private void convertEntries(CsvIterator it, String component) {
        LiquorFileBuilderFactory lfBuilderFactory = new LiquorFileBuilderFactory();
        LiquorFileBuilder lfBuilder = lfBuilderFactory.getBuilder(component);
        while (it.hasNext()) {
            it.next();
            lfBuilder.parseCSV(it);
        }
        lfBuilder.parseCSV(it);
    }

    public void releaseData() {
        this.entries.clear();
    }

    private String getBusinessNameSuffix() {
        return this.suffix;
    }

    private String getPricebookDirectory() {
        return this.directory;
    }
}

