/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.liquorfile.manager.builder;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.SyncPersistentObjectSnapshot;
import au.com.ordermate.persistence.synchronisation.Converter;
import au.com.ordermate.persistence.synchronisation.PersistenceSyncReceiver;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.integration.csv.CsvIterator;

public abstract class LiquorFileBuilder<T extends PersistentObject> {
    private Map<PropertiedObject.Property, String> propertiesToColumns = this.buildMappings();
    private static final Map<Class, Converter> converters = new HashMap<Class, Converter>(){
        {
            this.put(Long.class, new StringToLongConverter());
            this.put(Integer.class, new StringToIntegerConverter());
            this.put(Double.class, new StringToDoubleConverter());
            this.put(Price.class, new StringToPriceConverter());
        }
    };
    private boolean objectIDExistsInDB;

    public void parseCSV(CsvIterator it) {
        this.objectIDExistsInDB = false;
        T toCreate = this.getObjectToBuild(it);
        for (PropertiedObject.Property prop : ((PersistentObject)toCreate).getProperties()) {
            if (!this.propertiesToColumns.containsKey(prop) || prop.equals(PersistentObject.Properties.ID)) continue;
            ((PersistentObject)toCreate).setPropertyValue(prop, this.getObject(it.get(this.getColumnFromMap(prop)), prop));
        }
        if (this.objectIDExistsInDB) {
            ((Saveable)toCreate).save();
        } else {
            this.doNewObjectSave(toCreate);
        }
    }

    protected T getObjectToBuild(CsvIterator it) {
        return this.getObjectGivenID(this.getID(it.get(this.getColumnFromMap(PersistentObject.Properties.ID))));
    }

    protected Object getObject(String valueOfObject, PropertiedObject.Property prop) {
        if (this.checkPropIsFKLink(prop)) {
            return this.getFKLinkObject(valueOfObject, prop);
        }
        return this.convertIfNecessary(valueOfObject, prop);
    }

    protected long getID(String stringOfIDValue) {
        return (Long)this.getObject(stringOfIDValue, PersistentObject.Properties.ID);
    }

    private Object convertIfNecessary(String string, PropertiedObject.Property prop) {
        return this.convertIfNecessary(string, prop, prop.getObjectType());
    }

    private Object convertIfNecessary(String string, PropertiedObject.Property prop, Class toGetConvertorFor) {
        Converter propConvertor = converters.get(toGetConvertorFor);
        String toConvert = StringUtils.trimCustom(string);
        try {
            return propConvertor != null ? propConvertor.convert(string, prop, null) : string;
        }
        catch (NumberFormatException ex) {
            OrderMate.LOG.warn(" Issue Converting String=\"" + string + "\" into " + toGetConvertorFor + " For Property " + prop.getName() + " ##Exception## java.lang.NumberFormatException");
            return null;
        }
    }

    private Object getFKLinkObject(String idOfLinkedObject, PropertiedObject.Property prop) {
        Object toReturn = null;
        if (!StringUtils.isEmpty(idOfLinkedObject)) {
            Long toSearchOn = (Long)this.convertIfNecessary(idOfLinkedObject, prop, Long.class);
            toReturn = PersistenceManager.getByID(toSearchOn, prop.getObjectType());
        }
        return toReturn;
    }

    private boolean checkPropIsFKLink(PropertiedObject.Property prop) {
        return PersistentObject.class.isAssignableFrom(prop.getObjectType());
    }

    private T getObjectGivenID(long id) {
        Object toCreate = PersistenceManager.getByID(id, this.getObjectToBuildType());
        if (toCreate != null) {
            this.objectIDExistsInDB = true;
            return toCreate;
        }
        toCreate = this.createObject(id);
        return toCreate;
    }

    private void doNewObjectSave(T toSave) {
        try {
            PersistenceSyncReceiver.getInstance().saveOrUpdate(new SyncPersistentObjectSnapshot(((PersistentObject)toSave).getSnapshot()));
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot handle new Pricebook thing:", (Throwable)ex);
        }
    }

    protected String getColumnFromMap(PropertiedObject.Property prop) {
        return this.propertiesToColumns.get(prop);
    }

    protected void setObjectIDExistsInDB(boolean value) {
        this.objectIDExistsInDB = value;
    }

    protected Map<PropertiedObject.Property, String> getPropertiesToColumns() {
        return this.propertiesToColumns;
    }

    protected abstract T createObject(long var1);

    protected abstract Class getObjectToBuildType();

    protected abstract Map<PropertiedObject.Property, String> buildMappings();

    private static class StringToDoubleConverter
    extends StringConvertor {
        private static final Double ZERO = 0.0;

        private StringToDoubleConverter() {
        }

        @Override
        public Object convert(Object value, PropertiedObject.Property property, PersistentObjectI owner) {
            return !StringUtils.isEmpty((String)value) ? Double.parseDouble((String)value) : ZERO;
        }
    }

    private static class StringToIntegerConverter
    extends StringConvertor {
        private static final Integer ZERO = 0;

        private StringToIntegerConverter() {
        }

        @Override
        public Object convert(Object value, PropertiedObject.Property property, PersistentObjectI owner) {
            return !StringUtils.isEmpty((String)value) ? Integer.parseInt((String)value) : ZERO;
        }
    }

    private static class StringToLongConverter
    extends StringConvertor {
        private static final Integer ZERO = 0;

        private StringToLongConverter() {
        }

        @Override
        public Object convert(Object value, PropertiedObject.Property property, PersistentObjectI owner) {
            return !StringUtils.isEmpty((String)value) ? Long.parseLong((String)value) : (long)ZERO.intValue();
        }
    }

    private static class StringToPriceConverter
    extends StringConvertor {
        private StringToPriceConverter() {
        }

        @Override
        public Object convert(Object value, PropertiedObject.Property property, PersistentObjectI owner) {
            return !StringUtils.isEmpty((String)value) ? new Price(Double.parseDouble((String)value), 0.01) : Price.ZERO_DOLLAR;
        }
    }

    private static abstract class StringConvertor
    implements Converter {
        private StringConvertor() {
        }

        @Override
        public Class getType() {
            return String.class;
        }
    }
}

