/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.liquorfile.manager.builder;

import java.util.HashMap;
import java.util.Map;
import ordermate.integration.liquorfile.manager.builder.LiquorFileAPNBuilder;
import ordermate.integration.liquorfile.manager.builder.LiquorFileBuilder;
import ordermate.integration.liquorfile.manager.builder.LiquorFileCategoryBuilder;
import ordermate.integration.liquorfile.manager.builder.LiquorFileDepartmentBuilder;
import ordermate.integration.liquorfile.manager.builder.LiquorFileGroupBuilder;
import ordermate.integration.liquorfile.manager.builder.LiquorFileProductBuilder;
import ordermate.integration.liquorfile.manager.builder.LiquorFileSupplierBuilder;
import ordermate.integration.liquorfile.manager.builder.LiquorFileSupplierItemsBuilder;

public class LiquorFileBuilderFactory {
    private static final String PRODUCT_COMP_NAME = "FPRODUCT_";
    private static final String SUPP_ITEM_COMP_NAME = "FSUPPITEM_";
    private static final String SUPPLIER_COMP_NAME = "FSUPPLIER_";
    private static final String APN_COMP_NAME = "FAPN_";
    private static final String GROUP_COMP_NAME = "FGROUP_";
    private static final String CATEGORY_COMP_NAME = "FCATEGORY_";
    private static final String DEPARTMENT_COMP_NAME = "FDEPT_";
    private Map<String, LiquorFileBuilder> register = new HashMap<String, LiquorFileBuilder>();

    public LiquorFileBuilderFactory() {
        this.loadDefaultBuilders();
    }

    private void loadDefaultBuilders() {
        this.registerBuilder(PRODUCT_COMP_NAME, new LiquorFileProductBuilder());
        this.registerBuilder(SUPP_ITEM_COMP_NAME, new LiquorFileSupplierItemsBuilder());
        this.registerBuilder(SUPPLIER_COMP_NAME, new LiquorFileSupplierBuilder());
        this.registerBuilder(APN_COMP_NAME, new LiquorFileAPNBuilder());
        this.registerBuilder(GROUP_COMP_NAME, new LiquorFileGroupBuilder());
        this.registerBuilder(CATEGORY_COMP_NAME, new LiquorFileCategoryBuilder());
        this.registerBuilder(DEPARTMENT_COMP_NAME, new LiquorFileDepartmentBuilder());
    }

    public void registerBuilder(String toMapBy, LiquorFileBuilder builder) {
        this.register.put(toMapBy, builder);
    }

    public LiquorFileBuilder getBuilder(String component) {
        LiquorFileBuilder builder = this.register.get(component);
        if (builder == null) {
            throw new IllegalStateException("No Builder exists for \"" + component + "\"");
        }
        return builder;
    }
}

