/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.liquorfile.pricebook;

import au.com.bytecode.opencsv.CSVReader;
import au.com.ordermate.OrderMateLog;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.integration.csv.CSVExporter;
import ordermate.integration.liquorfile.pricebook.PricebookNonConUsageMapping;

public class PricebookManager {
    private static PricebookManager instance;
    private List lastInvalids;
    private List lastValids;

    private PricebookManager() {
    }

    public static final PricebookManager getInstance() {
        if (instance == null) {
            instance = new PricebookManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importLiquorfileIds(File file) {
        boolean fine = true;
        if (this.lastValids == null) {
            this.lastValids = new ArrayList();
        }
        this.lastValids.clear();
        if (this.lastInvalids == null) {
            this.lastInvalids = new ArrayList();
        }
        this.lastInvalids.clear();
        CSVReader reader = null;
        if (file == null) {
            throw new NullPointerException("Cannot read in a null file.");
        }
        try {
            reader = new CSVReader((Reader)new BufferedReader(new FileReader(file)));
            String[] header = reader.readNext();
            int PKCol = this.findColumn("Unique ID", header);
            int LFIDCol = this.findColumn("Liquorfile Number", header);
            if (PKCol == -1 || LFIDCol == -1) {
                throw new IllegalArgumentException("Liquorfile ID columns are corrupt, Unique ID: " + PKCol + " Liquorfile ID:" + LFIDCol);
            }
            String[] data = reader.readNext();
            while (data != null) {
                if (this.updateStockInventoryItemUsageLink(data, PKCol, LFIDCol)) {
                    this.lastValids.add(data[PKCol]);
                } else {
                    this.lastInvalids.add(data[PKCol]);
                }
                data = reader.readNext();
            }
        }
        catch (IOException ex) {
            fine = false;
            OrderMate.LOG.warn("Problem reading Pricebook linking file.", (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            fine = false;
            OrderMate.LOG.error("Problem reading the Pricebook linking file.", (Throwable)ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    fine = false;
                    OrderMate.LOG.error("Problem closing the Pricebook Linking file", (Throwable)ex);
                }
            }
        }
        return fine;
    }

    public final List getLastValidImports() {
        return this.lastValids;
    }

    public final List getLastInvalidImports() {
        return this.lastInvalids;
    }

    public final void writeUpdateToLogFile(File file) {
        if (file != null && this.lastValids != null && this.lastInvalids != null) {
            try {
                Iterator it;
                DataOutputStream out = new DataOutputStream(new FileOutputStream(file));
                out.writeBytes("Pricebook Linking Report.\n\nValid Imports:\n");
                if (this.lastValids.size() > 0) {
                    it = this.lastValids.iterator();
                    while (it.hasNext()) {
                        out.writeBytes(it.next().toString());
                        out.writeBytes("\n");
                    }
                } else {
                    out.writeBytes("No valid imports were found.");
                }
                out.writeBytes("\n\nInvalid Imports:\n");
                if (this.lastInvalids.size() > 0) {
                    it = this.lastInvalids.iterator();
                    while (it.hasNext()) {
                        out.writeBytes(it.next().toString());
                        out.writeBytes("\n");
                    }
                    out.writeBytes("Check that the Liquorfile IDs are not duplicates, and that the Unique IDs have not been altered.");
                } else {
                    out.writeBytes("No invalid imports were found.");
                }
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                OrderMateLog.LOG.error("Error writing to Pricebook Linking Log file.", (Throwable)ex);
            }
        }
    }

    private int findColumn(String columnToFind, String[] csvHeader) {
        int index = -1;
        for (int i = 0; i < csvHeader.length; ++i) {
            if (!columnToFind.equalsIgnoreCase(csvHeader[i])) continue;
            index = i;
            i = csvHeader.length;
        }
        return index;
    }

    private boolean updateStockInventoryItemUsageLink(String[] csvData, int pkCol, int LFIDCol) {
        boolean updated = true;
        Integer liquorfileId = null;
        try {
            liquorfileId = csvData[LFIDCol].trim().length() == 0 ? null : Integer.valueOf(csvData[LFIDCol]);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        Integer pkId = null;
        try {
            pkId = Integer.valueOf(csvData[pkCol]);
        }
        catch (NumberFormatException ex) {
            updated = false;
        }
        if (updated) {
            updated = false;
            StockInventoryUsageLink link = null;
            link = PersistenceManager.getObject(StockInventoryUsageLink.class, Query.select(StockInventoryUsageLink.class).equals(StockInventoryUsageLink.Properties.ID, pkId).toString(), null);
            if (link != null) {
                updated = this.updateLink(link, liquorfileId);
            }
        }
        return updated;
    }

    private boolean updateLink(StockInventoryUsageLink link, Integer liquorfileId) {
        link.setLiquorfileId(liquorfileId);
        link.saveChild();
        boolean updated = true;
        return updated;
    }

    public boolean exportLiquorfileIds(String filename, boolean ignoreLiquorfileIds, List usages) {
        if (usages == null) {
            throw new NullPointerException("Cannot export a null list of usages.");
        }
        if (filename == null) {
            throw new NullPointerException("Cannot export to a null file.");
        }
        if (filename.trim().length() == 0) {
            throw new IllegalArgumentException("Cannot export to an empty-named file.");
        }
        CSVExporter exporter = new CSVExporter(new PricebookNonConUsageMapping(usages, ignoreLiquorfileIds));
        File file = new File(filename);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new IllegalArgumentException("Cannot create parent directory, bad or no permission:" + file.getParentFile());
        }
        exporter.createExportFile(filename);
        return exporter.getError().trim().length() == 0;
    }

    public boolean isDuplicateID(StockInventoryUsageLink link, Integer liquorfileID) {
        List links;
        boolean notDuplicate = true;
        if (liquorfileID != null && link != null && (links = this.getAssignedLinks(liquorfileID, link.getInventoryItemUnit().getItem().getMenuGroup().getProfile())).size() > 0) {
            boolean bl = notDuplicate = links.size() == 0;
            if (links.size() == 1) {
                notDuplicate = ((StockInventoryUsageLink)links.get(0)).equals(link);
            }
        }
        return notDuplicate;
    }

    public List getAssignedLinks(Integer liquorfileID, InventoryProfile profile) {
        return PersistenceManager.getObjectList(StockInventoryUsageLink.class, Query.select(StockInventoryUsageLink.class).equals(StockInventoryUsageLink.Properties.LIQUORFILE_ID, liquorfileID).linkUsing(StockInventoryUsageLink.Properties.INVENTORY_ITEM_UNIT, InventoryItemUnit.Properties.ID).linkUsing(InventoryItemUnit.Properties.ITEM, InventoryItem.Properties.ID).linkUsing(InventoryItem.Properties.MENU_GROUP, InventoryGroup.Properties.ID).equals(InventoryGroup.Properties.PROFILE, profile).active(InventoryItemUnit.class).toString(), null);
    }

    public List getDuplicateUsageLinks(InventoryProfile profile) {
        ArrayList<StockInventoryUsageLink> toReturn = null;
        ObjectQuery uglyQuery = Query.select(StockInventoryUsageLink.class).linkUsing(StockInventoryUsageLink.Properties.INVENTORY_ITEM_UNIT, InventoryItemUnit.Properties.ID).linkUsing(InventoryItemUnit.Properties.ITEM, InventoryItem.Properties.ID).linkUsing(InventoryItem.Properties.MENU_GROUP, InventoryGroup.Properties.ID).linkUsing(InventoryGroup.Properties.PROFILE, InventoryProfile.Properties.ID).not().isNull(StockInventoryUsageLink.Properties.LIQUORFILE_ID).equals(InventoryProfile.Properties.ID, profile.getID()).active(InventoryItemUnit.class).groupBy(StockInventoryUsageLink.Properties.LIQUORFILE_ID);
        String uglySQL = uglyQuery.toString() + " HAVING COUNT(*) >1 LIMIT 5";
        List<StockInventoryUsageLink> duplicateIds = PersistenceManager.getObjectList(StockInventoryUsageLink.class, uglySQL, null);
        if (duplicateIds.size() > 0) {
            toReturn = new ArrayList<StockInventoryUsageLink>();
            Iterator<StockInventoryUsageLink> ids = duplicateIds.iterator();
            while (ids.hasNext()) {
                Integer nextID = ids.next().getLiquorfileId();
                toReturn.addAll(PersistenceManager.getObjectList(StockInventoryUsageLink.class, Query.select(StockInventoryUsageLink.class).linkUsing(StockInventoryUsageLink.Properties.INVENTORY_ITEM_UNIT, InventoryItemUnit.Properties.ID).linkUsing(InventoryItemUnit.Properties.ITEM, InventoryItem.Properties.ID).linkUsing(InventoryItem.Properties.MENU_GROUP, InventoryGroup.Properties.ID).linkUsing(InventoryGroup.Properties.PROFILE, InventoryProfile.Properties.ID).active(InventoryItemUnit.class).equals(InventoryProfile.Properties.ID, profile.getID()).equals(StockInventoryUsageLink.Properties.LIQUORFILE_ID, nextID).toString(), null));
            }
        }
        return toReturn;
    }

    public boolean allLinksValid() {
        return true;
    }
}

