/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.liquorfile.pricebook;

import au.com.ordermate.util.Price;
import java.util.List;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.integration.exportmapping.ExportTemplate;
import ordermate.integration.exportmapping.SimpleMapping;
import ordermate.integration.liquorfile.pricebook.PricebookNonConUsageExportTemplate;

public class PricebookNonConUsageMapping
extends SimpleMapping {
    private PricebookNonConUsageExportTemplate exportTemplate;
    private boolean ignoreLFID;

    public PricebookNonConUsageMapping(List newBusinessObjects, boolean ignoreLiquorfileIds) {
        super(newBusinessObjects, true);
        this.ignoreLFID = ignoreLiquorfileIds;
    }

    @Override
    protected void initMapping() {
        super.initMapping();
        this.exportTemplate = new PricebookNonConUsageExportTemplate();
        this.addMapping(this.exportTemplate.uniqueId, this.createAccessor("getUniqueId"));
        this.addMapping(this.exportTemplate.stockItem, this.createAccessor("getStockItem"));
        this.addMapping(this.exportTemplate.groupId, this.createAccessor("getGroupId"));
        this.addMapping(this.exportTemplate.groupDesc, this.createAccessor("getGroupDesc"));
        this.addMapping(this.exportTemplate.invItemUnit, this.createAccessor("getInvUnit"));
        this.addMapping(this.exportTemplate.barcode, this.createAccessor("getBarcode"));
        this.addMapping(this.exportTemplate.usage, this.createAccessor("getUsage"));
        this.addMapping(this.exportTemplate.quantity, this.createAccessor("getUnitQuantity"));
        this.addMapping(this.exportTemplate.cost, this.createAccessor("getCost"));
        this.addMapping(this.exportTemplate.liquorfileId, this.createAccessor("getLiquorfileId"));
    }

    @Override
    protected Class getBusinessObjectClass() {
        return StockInventoryUsageLink.class;
    }

    @Override
    protected ExportTemplate getTemplate() {
        return this.exportTemplate;
    }

    public String getUniqueId(StockInventoryUsageLink usageLink) {
        return usageLink.getID().toString();
    }

    public String getStockItem(StockInventoryUsageLink usageLink) {
        return usageLink.getStockItem().getLabel();
    }

    public String getGroupDesc(StockInventoryUsageLink usageLink) {
        return usageLink.getStockItem().getStockGroup().getLabelFull();
    }

    public String getGroupId(StockInventoryUsageLink usageLink) {
        return usageLink.getStockItem().getStockGroup().getID().toString();
    }

    public String getInvUnit(StockInventoryUsageLink usageLink) {
        return usageLink.getInventoryItemUnit().getLabel();
    }

    public String getUsage(StockInventoryUsageLink usageLink) {
        return Double.toString(usageLink.getQuantity().doubleValue());
    }

    public String getUnitQuantity(StockInventoryUsageLink usageLink) {
        double value = 1.0;
        if (value == 0.0) {
            return "";
        }
        return Double.toString(value);
    }

    public String getBarcode(StockInventoryUsageLink usageLink) {
        String toReturn = "";
        List<String> list = usageLink.getInventoryItemUnit().getBarcodes();
        if (list != null && list.size() > 0) {
            toReturn = list.get(0).toString();
        }
        return toReturn;
    }

    public String getCost(StockInventoryUsageLink usageLink) {
        Price cost = usageLink.getInventoryItemUnit().getIngredientCostExTax();
        if (cost != null) {
            return cost.toString(false);
        }
        return "";
    }

    public String getLiquorfileId(StockInventoryUsageLink usageLink) {
        String toReturn = null;
        toReturn = !this.ignoreLFID ? (usageLink.getLiquorfileId() != null ? usageLink.getLiquorfileId().toString() : "") : "";
        return toReturn;
    }
}

