/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.liquorfile.scandata;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.Price;
import java.util.Date;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.integration.liquorfile.scandata.ScandataInterface;
import ordermate.integration.liquorfile.scandata.ScandataTradingDayExport;

public class PersistentScandata
extends PersistentObject
implements ScandataInterface,
Saveable {
    public static final Props Properties = new Props();
    private Reference<StockInventoryUsageLink> stockInventoryUsageLink;
    private Reference<StockArea> stockArea;
    private Reference<StockGroup> stockGroup;
    private Reference<ScandataTradingDayExport> tradingDayExport;
    private Integer venueId;
    private String venueName;
    private Integer liquorfileId;
    private String unitDesc;
    private Integer unitSizeMl;
    private String stockGroupDesc;
    private Date dateOfSale;
    private Double qtySold;
    private String stockAreaDesc;
    private Integer packQty;
    private Price sellingPrice;
    private Price costPrice;
    private Price valueSold;
    private Price costOfSales;
    private Double purchasedQty;
    private Price purchasedValue;
    private Double qtyInStock;
    private Price valueInStock;

    public PersistentScandata() {
        this.stockInventoryUsageLink = this.createReference(PersistentScandata.Properties.STOCK_INVENTORY_USAGE_LINK);
        this.stockArea = this.createReference(PersistentScandata.Properties.STOCK_AREA);
        this.stockGroup = this.createReference(PersistentScandata.Properties.STOCK_GROUP);
        this.tradingDayExport = this.createReference(PersistentScandata.Properties.TRADING_DAY_EXPORT);
        this.sellingPrice = Price.ZERO_DOLLAR;
        this.costPrice = Price.ZERO_DOLLAR;
        this.valueSold = Price.ZERO_DOLLAR;
        this.costOfSales = Price.ZERO_DOLLAR;
        this.purchasedValue = Price.ZERO_DOLLAR;
        this.valueInStock = Price.ZERO_DOLLAR;
    }

    public PersistentScandata(ScandataInterface toCopy, ScandataTradingDayExport tradingDayExport) {
        this.stockInventoryUsageLink = this.createReference(PersistentScandata.Properties.STOCK_INVENTORY_USAGE_LINK);
        this.stockArea = this.createReference(PersistentScandata.Properties.STOCK_AREA);
        this.stockGroup = this.createReference(PersistentScandata.Properties.STOCK_GROUP);
        this.tradingDayExport = this.createReference(PersistentScandata.Properties.TRADING_DAY_EXPORT);
        this.sellingPrice = Price.ZERO_DOLLAR;
        this.costPrice = Price.ZERO_DOLLAR;
        this.valueSold = Price.ZERO_DOLLAR;
        this.costOfSales = Price.ZERO_DOLLAR;
        this.purchasedValue = Price.ZERO_DOLLAR;
        this.valueInStock = Price.ZERO_DOLLAR;
        this.venueId = toCopy.getVenueId();
        this.venueName = toCopy.getVenueName();
        this.liquorfileId = toCopy.getLiquorfileId();
        this.stockInventoryUsageLink.set(toCopy.getStockInventoryUsageLink());
        this.unitDesc = toCopy.getUnitDesc();
        this.unitSizeMl = toCopy.getUnitSizeMl();
        this.stockGroup.set(toCopy.getStockGroup());
        this.stockGroupDesc = toCopy.getStockGroupDesc();
        this.dateOfSale = toCopy.getDateOfSale();
        this.qtySold = toCopy.getQtySold();
        this.stockArea.set(toCopy.getStockArea());
        this.stockAreaDesc = toCopy.getStockAreaDesc();
        this.packQty = toCopy.getPackQuantity();
        this.sellingPrice = toCopy.getSellingPrice();
        this.costPrice = toCopy.getCostPrice();
        this.valueSold = toCopy.getValueSold();
        this.costOfSales = toCopy.getCostOfSales();
        this.purchasedQty = toCopy.getPurchasedQty();
        this.purchasedValue = toCopy.getPurchasedValue();
        this.qtyInStock = toCopy.getQtyInStock();
        this.valueInStock = toCopy.getValueInStock();
        this.setTradingDayExport(tradingDayExport);
    }

    @Override
    public Integer getVenueId() {
        return this.venueId;
    }

    public void setVenueId(Integer value) {
        this.venueId = value;
    }

    @Override
    public String getVenueName() {
        return this.venueName;
    }

    protected void setVenueName(String value) {
        this.venueName = value;
    }

    @Override
    public Integer getLiquorfileId() {
        return this.liquorfileId;
    }

    protected void setLiquorfileId(Integer value) {
        this.liquorfileId = value;
    }

    @Override
    public StockInventoryUsageLink getStockInventoryUsageLink() {
        return this.stockInventoryUsageLink.get();
    }

    protected void setStockInventoryUsageLink(StockInventoryUsageLink value) {
        this.stockInventoryUsageLink.set(value);
    }

    @Override
    public String getUnitDesc() {
        return this.unitDesc;
    }

    protected void setUnitDesc(String value) {
        this.unitDesc = value;
    }

    @Override
    public Integer getUnitSizeMl() {
        return this.unitSizeMl;
    }

    protected void setUnitSizeMl(Integer value) {
        this.unitSizeMl = value;
    }

    @Override
    public StockGroup getStockGroup() {
        return this.stockGroup.get();
    }

    protected void setStockGroup(StockGroup value) {
        this.stockGroup.set(value);
    }

    @Override
    public String getStockGroupDesc() {
        return this.stockGroupDesc;
    }

    protected void setStockGroupDesc(String value) {
        this.stockGroupDesc = value;
    }

    @Override
    public Date getDateOfSale() {
        return this.dateOfSale;
    }

    protected void setDateOfSale(Date value) {
        this.dateOfSale = value;
    }

    @Override
    public Double getQtySold() {
        return this.qtySold;
    }

    protected void setQtySold(Double newValue) {
        this.qtySold = newValue;
    }

    @Override
    public Double getPurchasedQty() {
        return this.purchasedQty;
    }

    protected void setPurchasedQty(Double newValue) {
        this.purchasedQty = newValue;
    }

    @Override
    public Price getPurchasedValue() {
        return this.purchasedValue;
    }

    protected void setPurchasedValue(Price value) {
        this.purchasedValue = value;
    }

    @Override
    public StockArea getStockArea() {
        return this.stockArea.get();
    }

    protected void setStockArea(StockArea newValue) {
        this.stockArea.set(newValue);
    }

    @Override
    public String getStockAreaDesc() {
        return this.stockAreaDesc;
    }

    protected void setStockAreaDesc(String value) {
        this.stockAreaDesc = value;
    }

    @Override
    public Integer getPackQuantity() {
        return this.packQty;
    }

    protected void setPackQuantity(Integer value) {
        this.packQty = value;
    }

    @Override
    public Price getSellingPrice() {
        return this.sellingPrice;
    }

    protected void setSellingPrice(Price newValue) {
        this.sellingPrice = newValue;
    }

    @Override
    public Price getCostPrice() {
        return this.costPrice;
    }

    protected void setCostPrice(Price value) {
        this.costPrice = value;
    }

    @Override
    public Price getValueSold() {
        return this.valueSold;
    }

    protected void setValueSold(Price value) {
        this.valueSold = value;
    }

    @Override
    public Price getCostOfSales() {
        return this.costOfSales;
    }

    protected void setCostOfSales(Price value) {
        this.costOfSales = value;
    }

    @Override
    public Double getQtyInStock() {
        return this.qtyInStock;
    }

    protected void setQtyInStock(Double newValue) {
        this.qtyInStock = newValue;
    }

    @Override
    public Price getValueInStock() {
        return this.valueInStock;
    }

    protected void setValueInStock(Price value) {
        this.valueInStock = value;
    }

    @Override
    public final boolean isPromotion() {
        return false;
    }

    @Override
    public Price getPromotionalPrice() {
        return Price.ZERO_DOLLAR;
    }

    public void setTradingDayExport(ScandataTradingDayExport value) {
        this.tradingDayExport.set(value);
    }

    public ScandataTradingDayExport getTradingDayExport() {
        return this.tradingDayExport.get();
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    public void aggregateData(ScandataInterface toMerge) {
        this.sellingPrice = new Price(this.getWeightedAverage(this.sellingPrice.doubleValue(), this.qtySold, toMerge.getSellingPrice().doubleValue(), toMerge.getQtySold()), 0.0);
        double potentialCost = this.getWeightedAverage(this.costPrice.doubleValue(), this.qtySold, toMerge.getCostPrice().doubleValue(), toMerge.getQtySold());
        if (potentialCost != 0.0) {
            this.costPrice = new Price(potentialCost, 0.0);
        }
        this.purchasedValue = this.purchasedValue.add(toMerge.getPurchasedValue());
        this.qtyInStock = this.qtyInStock + toMerge.getQtyInStock();
        this.qtySold = this.qtySold + toMerge.getQtySold();
        this.purchasedQty = this.purchasedQty + toMerge.getPurchasedQty();
        this.valueSold = this.sellingPrice.multiply(this.qtySold);
        this.costOfSales = this.costPrice.multiply(this.qtySold);
        this.valueInStock = this.costPrice.multiply(this.qtyInStock);
    }

    private double getWeightedAverage(double value1, double qty1, double value2, double qty2) {
        if (qty1 == 0.0 && qty2 == 0.0) {
            return 0.0;
        }
        return (value1 * qty1 + value2 * qty2) / (qty1 + qty2);
    }

    protected Integer getPackQty() {
        return this.packQty;
    }

    protected void setPackQty(Integer newPackQty) {
        this.packQty = newPackQty;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property VENUE_ID;
        public PropertiedObject.Property VENUE_NAME;
        public PropertiedObject.Property LIQUORFILE_ID;
        public PropertiedObject.Property<StockInventoryUsageLink> STOCK_INVENTORY_USAGE_LINK;
        public PropertiedObject.Property UNIT_DESC;
        public PropertiedObject.Property UNIT_SIZE_ML;
        public PropertiedObject.Property<StockGroup> STOCK_GROUP;
        public PropertiedObject.Property STOCK_GROUP_DESC;
        public PropertiedObject.Property DATE_OF_SALE;
        public PropertiedObject.Property QTY_SOLD;
        public PropertiedObject.Property<StockArea> STOCK_AREA;
        public PropertiedObject.Property STOCK_AREA_DESC;
        public PropertiedObject.Property PACK_QTY;
        public PropertiedObject.Property SELLING_PRICE;
        public PropertiedObject.Property COST_PRICE;
        public PropertiedObject.Property VALUE_SOLD;
        public PropertiedObject.Property COST_OF_SALES;
        public PropertiedObject.Property PURCHASED_QTY;
        public PropertiedObject.Property PURCHASED_VALUE;
        public PropertiedObject.Property QTY_IN_STOCK;
        public PropertiedObject.Property VALUE_IN_STOCK;
        public PropertiedObject.Property<ScandataTradingDayExport> TRADING_DAY_EXPORT;
    }
}

