/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.liquorfile.scandata;

import java.io.IOException;
import ordermate.OrderMate;
import ordermate.database.misc.TradingDay;
import ordermate.integration.liquorfile.scandata.ScandataManager;
import ordermate.scheduler.Task;

public class ScandataExportTask
implements Task {
    private TradingDay dayOfInterest;

    @Override
    public String getName() {
        return "Scandata Automatic Export Task";
    }

    @Override
    public void setData(Object data) {
        if (data instanceof TradingDay) {
            TradingDay day;
            this.dayOfInterest = day = (TradingDay)data;
            if (this.dayOfInterest.isOpen()) {
                this.dayOfInterest = day.getPreviousTradingDay();
            }
        } else {
            OrderMate.LOG.error("Scandata export will fail as it is designed as a Trading Day task.");
        }
    }

    @Override
    public void run() {
        ScandataManager manager = new ScandataManager();
        if (this.dayOfInterest == null) {
            OrderMate.LOG.error("Could not perform scandata export, previous TradingDay was null.");
            return;
        }
        try {
            manager.exportScandata(this.dayOfInterest);
        }
        catch (IllegalArgumentException ex) {
            OrderMate.LOG.error("Error while performing scandata export,\ncheck that all Liquorfile links are valid:", (Throwable)ex);
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Error while performing scandata export:", (Throwable)ex);
        }
    }

    public Object getData() {
        return this.dayOfInterest;
    }
}

