/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.liquorfile.scandata;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ordermate.database.integration.LiquorfileConfiguration;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.misc.TradingDay;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.integration.csv.CSVExporter;
import ordermate.integration.liquorfile.pricebook.PricebookManager;
import ordermate.integration.liquorfile.scandata.PersistentScandata;
import ordermate.integration.liquorfile.scandata.ScandataMapping;
import ordermate.integration.liquorfile.scandata.ScandataReportObject;
import ordermate.integration.liquorfile.scandata.ScandataTradingDayExport;

public class ScandataManager {
    private ScandataTradingDayExport retrieveTradingDayExport(TradingDay tradingDay) {
        String query = Query.select(ScandataTradingDayExport.class).equals(ScandataTradingDayExport.Properties.TRADING_DAY, tradingDay).limit(1).toString();
        return PersistenceManager.getObject(ScandataTradingDayExport.class, query, null);
    }

    public final ScandataTradingDayExport getScandataExport(TradingDay day) {
        if (day == null) {
            throw new NullPointerException("Cannot get Scandata Export for a null Trading Day");
        }
        ScandataTradingDayExport export = this.retrieveTradingDayExport(day);
        if (export == null && PricebookManager.getInstance().allLinksValid()) {
            this.generateScandataReport(day);
            export = this.retrieveTradingDayExport(day);
        }
        return export;
    }

    public final List<StockInventoryUsageLink> getDuplicateLFIDs() {
        String SQL2 = Query.select(StockInventoryUsageLink.class).linkUsing(StockInventoryUsageLink.Properties.INVENTORY_ITEM_UNIT, InventoryItemUnit.Properties.ID).linkUsing(InventoryItemUnit.Properties.ITEM, InventoryItem.Properties.ID).linkUsing(InventoryItem.Properties.MENU_GROUP, InventoryGroup.Properties.ID).linkUsing(InventoryGroup.Properties.PROFILE, InventoryProfile.Properties.ID).equals(InventoryItemUnit.Properties.SYSTEM_STATE, "ACTIVE").not().isNull(StockInventoryUsageLink.Properties.LIQUORFILE_ID).groupBy(InventoryProfile.Properties.ID).groupBy(StockInventoryUsageLink.Properties.LIQUORFILE_ID).toString();
        SQL2 = SQL2 + " HAVING COUNT(*) >1";
        return PersistenceManager.getObjectList(StockInventoryUsageLink.class, SQL2, null);
    }

    private final List aggregateTradingDay(ScandataTradingDayExport export) {
        List<StockInventoryUsageLink> duplicates = this.getDuplicateLFIDs();
        if (duplicates.size() > 0) {
            return this.aggregateTradingDay(export, duplicates);
        }
        return export.getScandataEntries();
    }

    private List aggregateTradingDay(ScandataTradingDayExport export, List<StockInventoryUsageLink> duplicates) {
        ArrayList<PersistentScandata> aggregatedList = new ArrayList<PersistentScandata>(export.getScandataEntries());
        HashMap<Integer, PersistentScandata> uniqueMap = new HashMap<Integer, PersistentScandata>();
        ArrayList<PersistentScandata> toRemove = new ArrayList<PersistentScandata>();
        for (StockArea nextArea : StockArea.getStockAreas()) {
            if (!nextArea.isScandataExported()) continue;
            uniqueMap.clear();
            toRemove.clear();
            for (StockInventoryUsageLink link : duplicates) {
                Integer value = link.getLiquorfileId();
                for (PersistentScandata nextEntry : aggregatedList) {
                    if (!nextEntry.getStockArea().equals(nextArea) || !value.equals(nextEntry.getLiquorfileId())) continue;
                    if (!uniqueMap.containsKey(value)) {
                        uniqueMap.put(value, new PersistentScandata(nextEntry, null));
                    } else {
                        ((PersistentScandata)uniqueMap.get(value)).aggregateData(nextEntry);
                    }
                    toRemove.add(nextEntry);
                }
            }
            aggregatedList.addAll(uniqueMap.values());
            aggregatedList.removeAll(toRemove);
        }
        return aggregatedList;
    }

    public final File exportScandata(TradingDay day) throws IOException, IllegalArgumentException {
        return this.exportScandata(this.getScandataExport(day));
    }

    public final File exportScandata(ScandataTradingDayExport export) throws IOException, IllegalArgumentException {
        List toExport;
        CSVExporter exporter;
        LiquorfileConfiguration config = LiquorfileConfiguration.getInstance();
        File directory = new File(config.getScandataExportDir());
        if (export == null) {
            throw new IllegalArgumentException("Cannot export a null ScandataTradingDayExport.");
        }
        if (config.getScandataExportDir() == null || config.getScandataExportDir().isEmpty()) {
            throw new IllegalArgumentException("Cannot export, directory has not been set.");
        }
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Scandata export directory parent directory could not be created.");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Scandata Export directory is not a directory");
        }
        StringBuilder builder = new StringBuilder(directory.toString());
        builder.append(File.separator);
        builder.append(export.getFilename());
        File file = new File(builder.toString());
        if (file.exists() && !file.delete()) {
            OrderMateLog.LOG.warn("Could not delete Scandata export file: " + file.toString());
        }
        if (!(exporter = new CSVExporter(new ScandataMapping(toExport = this.aggregateTradingDay(export)))).createExportFile(file.toString())) {
            file = null;
            export.setExported(false);
        } else {
            export.setExported(true);
        }
        export.save();
        return file;
    }

    public List determineMissingScandata() {
        LiquorfileConfiguration config = LiquorfileConfiguration.getInstance();
        if (config.getScandataStartDate() == null) {
            throw new IllegalArgumentException("No Scandata starting date has been specified.");
        }
        List<TradingDay> days = TradingDay.ReportDates.getTradingDaysOnOrAfter(config.getScandataStartDate());
        ArrayList<TradingDay> missingFiles = new ArrayList<TradingDay>();
        for (TradingDay nextDay : days) {
            ScandataTradingDayExport export;
            if (nextDay.isOpen() || (export = this.retrieveTradingDayExport(nextDay)) != null && export.isExported()) continue;
            missingFiles.add(nextDay);
        }
        return missingFiles;
    }

    public String createFilename(TradingDay day) {
        StringBuilder SB = new StringBuilder(this.padZeroes(LiquorfileConfiguration.getInstance().getLiquorfileId(), 3));
        Calendar cal = Calendar.getInstance();
        cal.setTime(day.getDate());
        SB.append(this.padZeroes(cal.get(5), 2));
        SB.append(this.padZeroes(cal.get(2) + 1, 2));
        SB.append(this.padZeroes(cal.get(1) % 100, 2));
        SB.append(".csv");
        return SB.toString();
    }

    private void generateScandataReport(TradingDay day) {
        ScandataTradingDayExport export = new ScandataTradingDayExport();
        export.setFilename(this.createFilename(day));
        export.setTradingDay(day);
        export.save();
        List<StockArea> stockAreas = PersistenceManager.getObjectList(StockArea.class, Query.select(StockArea.class).equals(StockArea.Properties.SCANDATA_EXPORTED, "1").equals(StockArea.Properties.SCANDATA_CONSOLIDATED, "0").toString(), PersistenceManager.EMPTY_OBJECT_ARRAY);
        List<StockInventoryUsageLink> usageLinks = PersistenceManager.getObjectList(StockInventoryUsageLink.class, Query.select(StockInventoryUsageLink.class).toString(), PersistenceManager.EMPTY_OBJECT_ARRAY);
        for (StockInventoryUsageLink nextLink : usageLinks) {
            for (StockArea nextArea : stockAreas) {
                ScandataReportObject reportObject = new ScandataReportObject(nextLink, day, nextArea);
                if (!reportObject.hasQuantity()) continue;
                PersistentScandata persistedData = new PersistentScandata(reportObject, export);
                persistedData.save();
            }
        }
    }

    private String padZeroes(Integer value, int numberOfFigures) {
        String rawString = value == null ? "" : value.toString();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < numberOfFigures - rawString.length(); ++i) {
            builder.append("0");
        }
        builder.append(rawString);
        return builder.toString();
    }

    public Collection getScandataExportsBetween(Date fromDate, Date toDate) {
        String query = Query.select(ScandataTradingDayExport.class).linkUsing(ScandataTradingDayExport.Properties.TRADING_DAY, TradingDay.Properties.ID).wherePropertyBetween(TradingDay.Properties.DATE, fromDate, toDate, SQLDateType.DATE).orderByDesc(TradingDay.Properties.DATE).toString();
        return PersistenceManager.getObjectList(ScandataTradingDayExport.class, query, null);
    }

    public File regenerateScandata(ScandataTradingDayExport toRegenerate) throws IOException {
        TradingDay day = toRegenerate.getTradingDay();
        toRegenerate.delete();
        return this.exportScandata(day);
    }
}

