/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.liquorfile.scandata;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.List;
import ordermate.integration.exportmapping.ExportTemplate;
import ordermate.integration.exportmapping.SimpleMapping;
import ordermate.integration.liquorfile.scandata.PersistentScandata;
import ordermate.integration.liquorfile.scandata.ScandataExportTemplate;

public class ScandataMapping
extends SimpleMapping {
    private DecimalFormat roundedFormat = new DecimalFormat("#0.0###");
    private DateFormat localDateFormat = DateFormat.getDateInstance();
    private ScandataExportTemplate exportTemplate;

    public ScandataMapping(List objects) {
        super(objects, true);
    }

    @Override
    protected void initMapping() {
        super.initMapping();
        this.exportTemplate = new ScandataExportTemplate();
        this.addMapping(this.exportTemplate.venueId, this.createBusinessObjectAccessor("getVenueId"));
        this.addMapping(this.exportTemplate.venueName, this.createBusinessObjectAccessor("getVenueName"));
        this.addMapping(this.exportTemplate.liquorFileNo, this.createBusinessObjectAccessor("getLiquorfileId"));
        this.addMapping(this.exportTemplate.hotelsStockNumber, this.createAccessor("getStockInventoryUsageId"));
        this.addMapping(this.exportTemplate.unitDescription, this.createBusinessObjectAccessor("getUnitDesc"));
        this.addMapping(this.exportTemplate.unitSizeMl, this.createAccessor("getUnitSizeMl"));
        this.addMapping(this.exportTemplate.departmentNumber, this.createAccessor("getStockGroupId"));
        this.addMapping(this.exportTemplate.departmentDescription, this.createBusinessObjectAccessor("getStockGroupDesc"));
        this.addMapping(this.exportTemplate.dateOfSale, this.createAccessor("getDateOfSale"));
        this.addMapping(this.exportTemplate.qtySold, this.createAccessor("getQtySold"));
        this.addMapping(this.exportTemplate.sellingPrice, this.createAccessor("getSellingPrice"));
        this.addMapping(this.exportTemplate.locationNo, this.createAccessor("getStockAreaId"));
        this.addMapping(this.exportTemplate.locationName, this.createBusinessObjectAccessor("getStockAreaDesc"));
        this.addMapping(this.exportTemplate.packQty, this.createBusinessObjectAccessor("getPackQuantity"));
        this.addMapping(this.exportTemplate.costPrice, this.createAccessor("getCostPrice"));
        this.addMapping(this.exportTemplate.valueSold, this.createAccessor("getValueSold"));
        this.addMapping(this.exportTemplate.costOfSales, this.createAccessor("getCostOfSales"));
        this.addMapping(this.exportTemplate.purchasedQty, this.createAccessor("getPurchasedQty"));
        this.addMapping(this.exportTemplate.purchasedValue, this.createAccessor("getPurchasedValue"));
        this.addMapping(this.exportTemplate.qtyInStock, this.createAccessor("getQtyInStock"));
        this.addMapping(this.exportTemplate.valueInStock, this.createAccessor("getValueInStock"));
        this.addMapping(this.exportTemplate.promotionFlag, "0");
        this.addMapping(this.exportTemplate.promotionPrice, "0.0");
    }

    @Override
    protected Class getBusinessObjectClass() {
        return PersistentScandata.class;
    }

    @Override
    protected ExportTemplate getTemplate() {
        return this.exportTemplate;
    }

    public String getValueInStock(PersistentScandata scandata) {
        return this.roundedFormat.format(scandata.getValueInStock());
    }

    public String getCostPrice(PersistentScandata scandata) {
        return this.roundedFormat.format(scandata.getCostPrice());
    }

    public String getSellingPrice(PersistentScandata scandata) {
        return this.roundedFormat.format(scandata.getSellingPrice());
    }

    public String getCostOfSales(PersistentScandata scandata) {
        return this.roundedFormat.format(scandata.getCostOfSales());
    }

    public String getQtyInStock(PersistentScandata scandata) {
        return this.roundedFormat.format(scandata.getQtyInStock());
    }

    public String getQtySold(PersistentScandata scandata) {
        return this.roundedFormat.format(scandata.getQtySold());
    }

    public String getPurchasedValue(PersistentScandata scandata) {
        return this.roundedFormat.format(scandata.getPurchasedValue());
    }

    public String getPurchasedQty(PersistentScandata scandata) {
        return this.roundedFormat.format(scandata.getPurchasedQty());
    }

    public String getValueSold(PersistentScandata scandata) {
        return this.roundedFormat.format(scandata.getValueSold());
    }

    public String getDateOfSale(PersistentScandata scandata) {
        return this.localDateFormat.format(scandata.getDateOfSale());
    }

    public String getUnitSizeMl(PersistentScandata scandata) {
        String toReturn = Integer.valueOf(0).equals(scandata.getUnitSizeMl()) ? "0" : scandata.getUnitSizeMl().toString();
        return toReturn;
    }

    public String getStockAreaId(PersistentScandata scandata) {
        return scandata.getStockArea().getID().toString();
    }

    public String getStockGroupId(PersistentScandata scandata) {
        return scandata.getStockGroup().getID().toString();
    }

    public String getStockInventoryUsageId(PersistentScandata scandata) {
        return scandata.getStockInventoryUsageLink() == null ? "" : scandata.getStockInventoryUsageLink().getID().toString();
    }
}

