/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.liquorfile.scandata;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.units.UnitScales;
import au.com.ordermate.util.Price;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.integration.LiquorfileConfiguration;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.SalesComponent;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockInvoice;
import ordermate.database.stock.StockInvoiceEntry;
import ordermate.database.stock.usage.PersistentStockUsage;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.integration.liquorfile.scandata.ScandataInterface;
import stockmate.database.interfaces.stock.MeasureUnitI;

public class ScandataReportObject
implements ScandataInterface {
    private Price costPrice;
    private Price salePrice;
    private Price costsTotal;
    private Price salesTotal;
    private Price costsIncoming;
    private Date openDate;
    private Date closeDate;
    private Double qtyOutgoing;
    private Double qtyIncoming;
    private StockInventoryUsageLink usageLink;
    private TradingDay tradingDay;
    private StockArea stockArea;

    public ScandataReportObject(StockInventoryUsageLink unitUsageLink, TradingDay dayOfTrade, StockArea areaOfStock) {
        this.usageLink = unitUsageLink;
        this.tradingDay = dayOfTrade;
        this.stockArea = areaOfStock;
        this.createSummary();
    }

    private void createSummary() {
        if (this.usageLink == null) {
            throw new NullPointerException("A ScandataReportObject may not report on a null object.");
        }
        if (this.tradingDay == null) {
            throw new NullPointerException("A ScandataReportObject may not report on a null TradingDay.");
        }
        if (this.tradingDay.getCloseDate() == null) {
            throw new IllegalArgumentException("A ScandataReportObject may only summarise on closed TradingDays.");
        }
        if (this.stockArea == null) {
            throw new NullPointerException("A ScandataReportObject may not report on a null StockArea.");
        }
        this.openDate = this.tradingDay.getOpenDateTime();
        this.closeDate = this.tradingDay.getCloseDateTime();
        if (this.getPackQuantity() > 0) {
            this.summariseOutgoing();
            this.summariseIncoming();
        } else {
            this.qtyOutgoing = 0.0;
            this.qtyIncoming = 0.0;
        }
    }

    private void summariseOutgoing() {
        ObjectQuery outgoingQuery = Query.select(PersistentStockUsage.class).linkUsing(PersistentStockUsage.Properties.SALES_COMPONENT, SalesComponent.Properties.ID).equals(PersistentStockUsage.Properties.STOCK_AREA, this.stockArea).equals(PersistentStockUsage.Properties.STOCK_ITEM, this.usageLink.getStockItem()).equals(SalesComponent.Properties.UNIT, this.usageLink.getInventoryItemUnit()).wherePropertyBetween(PersistentStockUsage.Properties.USAGE_DATE, this.openDate, this.closeDate, SQLDateType.TIMESTAMP).equals(PersistentStockUsage.Properties.USAGE_STATE, "NORMAL");
        List<PersistentStockUsage> listOfSales = PersistenceManager.getObjectList(PersistentStockUsage.class, outgoingQuery.toString(), null);
        Price tallySales = new Price(0.0, 0.0);
        Price tallyCosts = new Price(0.0, 0.0);
        double tallyQty = 0.0;
        for (PersistentStockUsage nextUsage : listOfSales) {
            SalesComponent component = nextUsage.getSalesComponent();
            tallyCosts = tallyCosts.add(nextUsage.getHistoricalCost());
            tallySales = tallySales.add(component.getSavedUnitPrice().multiply(component.getSalesItem().getQuantity()));
            tallyQty += nextUsage.getQuantityUsed().doubleValue();
        }
        this.salesTotal = tallySales;
        this.costsTotal = tallyCosts;
        if (tallyQty != 0.0) {
            double quantity = this.usageLink.getQuantity().doubleValue() / this.usageLink.getStockItem().getDisplayMeasureUnitContainer().getMultiplier();
            this.salePrice = new Price(tallySales.doubleValue() / (tallyQty /= quantity), 0.0);
            this.costPrice = new Price(tallyCosts.doubleValue() / tallyQty, 0.0);
        } else {
            this.salePrice = Price.ZERO_DOLLAR;
            this.costPrice = Price.ZERO_DOLLAR;
        }
        this.qtyOutgoing = tallyQty;
    }

    private void summariseIncoming() {
        if (this.usageLink.getQuantity().equals(this.usageLink.getStockItem().getPurchaseQty())) {
            ObjectQuery incomingQuery = Query.select(StockInvoiceEntry.class).linkUsing(StockInvoiceEntry.Properties.INVOICE, StockInvoice.Properties.ID).equals(StockInvoiceEntry.Properties.STOCK_ITEM, this.usageLink.getStockItem()).equals(StockInvoice.Properties.STOCK_AREA, this.stockArea).equals(StockInvoice.Properties.INVOICE_TYPE, "Invoice").wherePropertyBetween(StockInvoice.Properties.DATE, this.openDate, this.closeDate, SQLDateType.TIMESTAMP).active(StockInvoice.class);
            List<StockInvoiceEntry> invoiceList = PersistenceManager.getObjectList(StockInvoiceEntry.class, incomingQuery.toString(), null);
            Iterator<StockInvoiceEntry> invoiceEntries = invoiceList.iterator();
            Price costTally = new Price(0.0, 0.0);
            double qtyTally = 0.0;
            while (invoiceEntries.hasNext()) {
                StockInvoiceEntry nextEntry = invoiceEntries.next();
                qtyTally += nextEntry.getTotalReceivedQuantity().doubleValue();
                costTally = costTally.add(nextEntry.getPricePaid());
            }
            if (this.costPrice == null || this.costPrice.doubleValue() == 0.0) {
                this.costPrice = this.usageLink.getStockItem().getCurrentReplacementCost();
            }
            this.costsIncoming = costTally;
            this.qtyIncoming = qtyTally;
        } else {
            this.costsIncoming = Price.ZERO_DOLLAR;
            this.qtyIncoming = 0.0;
        }
    }

    public boolean hasQuantity() {
        Double incoming = this.getPurchasedQty();
        Double outgoing = this.getQtySold();
        return incoming != null && incoming > 0.0 || outgoing != null && outgoing > 0.0;
    }

    @Override
    public Price getCostOfSales() {
        return this.costsTotal;
    }

    @Override
    public Price getCostPrice() {
        return this.costPrice;
    }

    @Override
    public Date getDateOfSale() {
        return this.openDate;
    }

    @Override
    public Integer getLiquorfileId() {
        return this.usageLink.getLiquorfileId();
    }

    @Override
    public Integer getPackQuantity() {
        return (int)(this.usageLink.getQuantity().doubleValue() / (double)Math.max(1, this.getUnitSizeMl()));
    }

    @Override
    public Price getPromotionalPrice() {
        return Price.ZERO_DOLLAR;
    }

    @Override
    public Double getPurchasedQty() {
        return this.qtyIncoming;
    }

    @Override
    public Price getPurchasedValue() {
        return this.costsIncoming;
    }

    @Override
    public Double getQtyInStock() {
        return this.usageLink.getStockItem().getDisplayMeasureUnitContainer().getMultiplier() * this.usageLink.getStockItem().getStockOnHand(this.stockArea).doubleValue() / (this.usageLink.getStockItem().getPurchaseQty().doubleValue() * this.usageLink.getQuantity().doubleValue());
    }

    @Override
    public Price getSellingPrice() {
        return this.salePrice;
    }

    @Override
    public Double getQtySold() {
        return this.qtyOutgoing;
    }

    @Override
    public StockArea getStockArea() {
        return this.stockArea;
    }

    @Override
    public String getStockAreaDesc() {
        return this.stockArea.getLabel();
    }

    @Override
    public String getStockGroupDesc() {
        return this.usageLink.getStockItem().getStockGroup().getName();
    }

    @Override
    public StockGroup getStockGroup() {
        return this.usageLink.getStockItem().getStockGroup();
    }

    @Override
    public String getUnitDesc() {
        return this.usageLink.getInventoryItemUnit().getItemLabel();
    }

    @Override
    public StockInventoryUsageLink getStockInventoryUsageLink() {
        return this.usageLink;
    }

    @Override
    public Integer getUnitSizeMl() {
        Integer toReturn;
        MeasureUnitI unit = this.usageLink.getStockItem().getDisplayMeasureUnit();
        MeasureUnitContainer cont = this.usageLink.getStockItem().getDisplayMeasureUnitContainer();
        if (!unit.getScale().equals(UnitScales.Units.name())) {
            double qtyPer = cont.getQuantityPerContainer();
            double displayMeasure = unit.getValue();
            toReturn = (int)(qtyPer * displayMeasure);
        } else {
            toReturn = 0;
        }
        return toReturn;
    }

    @Override
    public Price getValueInStock() {
        return new Price(this.usageLink.getStockItem().getCostOfStockOnHandIncTax(this.stockArea).doubleValue() * this.usageLink.getStockItem().getStockOnHand(this.stockArea).doubleValue(), 0.0);
    }

    @Override
    public Price getValueSold() {
        return this.salesTotal;
    }

    @Override
    public Integer getVenueId() {
        return LiquorfileConfiguration.getInstance().getLiquorfileId();
    }

    @Override
    public String getVenueName() {
        String venueName = LiquorfileConfiguration.getInstance().getLiquorfileCustomerName();
        if (venueName == null) {
            venueName = "No Name";
        }
        return venueName;
    }

    @Override
    public boolean isPromotion() {
        return false;
    }
}

